package com.bizunited.platform.core.configuration;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.service.image.FileUpdateService;

/**
  * 文件附件模块的无效文件清理任务
 * @author yinwenjie
 */
@Configuration
@EnableScheduling
public class FileServiceEffectiveTask {
  
  @Autowired
  private FileUpdateService fileUpdateService;
  
  /**
   * 每天凌晨0:30执行
   */
  @Scheduled(cron = "* 30 0 * * ?")
  public void effectiveTask() {
    Date currentDate = new Date();
    List<OrdinaryFileEntity> oldFiles = this.fileUpdateService.findByEffectiveDate(currentDate);
    if (oldFiles == null || oldFiles.isEmpty()) {
      return;
    }

    // 开始删除
    List<String> oldFileIds = oldFiles.stream().map(OrdinaryFileEntity::getId).collect(Collectors.toList());
    this.fileUpdateService.deleteFiles(oldFileIds.toArray(new String[] {}));
  }
}
