package com.bizunited.platform.core.configuration;

import org.redisson.spring.session.config.EnableRedissonHttpSession;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * 技术中台“底座”模块主配置过程
 * @author yinwenjie
 */
@Configuration
//启动缓存
@EnableCaching
//启动spring session
@EnableRedissonHttpSession(keyPrefix="spring:session:sessions:")
@ComponentScan(basePackages= {"com.bizunited.platform.core","com.bizunited.platform.rbac.server"})
public class PlatformCoreConfig {

}