package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.security.ButtonServiceImpl;
import com.bizunited.platform.core.service.security.CompetenceServiceImpl;
import com.bizunited.platform.core.service.security.OrganizationServiceImpl;
import com.bizunited.platform.core.service.security.PositionServiceImpl;
import com.bizunited.platform.core.service.security.RoleServiceImpl;
import com.bizunited.platform.core.service.security.UserGroupServiceImpl;
import com.bizunited.platform.core.service.security.UserServiceImpl;
import com.bizunited.platform.rbac.server.service.ButtonService;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.service.UserService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 该配置信息中，携带了关于RBAC结构的默认实现。如果试用本starter的业务工程重新实现了RBAC的相关接口，则这里的配置将失效
 * @author yinwenjie
 */
@Configuration
public class RbacDefaultConfig {
  @Bean(name="CompetenceService")
  @ConditionalOnMissingBean
  public CompetenceService getCompetenceService() {
    return new CompetenceServiceImpl();
  }
  @Bean(name="OrganizationService")
  @ConditionalOnMissingBean
  public OrganizationService getOrganizationService() {
    return new OrganizationServiceImpl();
  }
  @Bean(name="PositionService")
  @ConditionalOnMissingBean
  public PositionService getPositionService() {
    return new PositionServiceImpl();
  }
  @Bean(name="RoleService")
  @ConditionalOnMissingBean
  public RoleService getRoleService() {
    return new RoleServiceImpl();
  }
  @Bean(name="UserGroupService")
  @ConditionalOnMissingBean
  public UserGroupService getUserGroupService() {
    return new UserGroupServiceImpl();
  }
  @Bean(name="UserService")
  @ConditionalOnMissingBean
  public UserService getUserService() {
    return new UserServiceImpl();
  }
  @Bean(name="ButtonService")
  @ConditionalOnMissingBean
  public ButtonService getButtonService() {
    return new ButtonServiceImpl();
  }
}