package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.service.CodeRuleService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * CodeGenerateRoleController 编码生成规则
 *
 * @description:
 * @author: yanwe
 * @date: 12/Jun/2019 16:46
 */
@RestController
@RequestMapping("/v1/nebula/codeRules")
public class CodeRuleController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(CodeRuleController.class);

  @Autowired private CodeRuleService codeRuleService;

  @ApiOperation(value = "创建编码生成规则")
  @RequestMapping(value = "", method = RequestMethod.POST)
  public ResponseModel create(
      @ApiParam(name = "编码生成规则信息") @RequestBody CodeRuleEntity entity) {
    LOGGER.debug("创建编码生成规则：{}", JSON.toJSONString(entity));
    try {
      CodeRuleEntity codeRuleEntity = codeRuleService.create(entity);
      return this.buildHttpResultW(codeRuleEntity, "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "修改编码生成规则")
  @RequestMapping(value = "", method = RequestMethod.PATCH)
  public ResponseModel update(
      @ApiParam(name = "编码生成规则信息") @RequestBody CodeRuleEntity entity) {
    LOGGER.debug("修改编码生成规则：{}", JSON.toJSONString(entity));
    try {
      CodeRuleEntity codeRuleEntity = codeRuleService.update(entity);
      return this.buildHttpResultW(codeRuleEntity, "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "生成/修改编码生成规则脚本内容")
  @RequestMapping(value = "/updateContent", method = RequestMethod.PATCH)
  public ResponseModel updateContent(
      @ApiParam(name = "编码生成规则ID") @RequestParam(name = "ruleId") String ruleId,
      @ApiParam(name = "编码生成规则脚本内容") @RequestParam(name = "content") String content) {
    try {
      return this.buildHttpResultW(codeRuleService.updateContent(ruleId, content));
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "查询业务编码生成规则脚本内容")
  @RequestMapping(value = "/findContentByCode", method = RequestMethod.GET)
  public ResponseModel findContentByCode(
      @ApiParam(name = "编码生成规则的业务编码") @RequestParam(name = "code") String code) {
    try {
      String content = codeRuleService.findContentByCode(code);
      return this.buildHttpResultW(content, "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "按照条件搜索编码生成规则，不支持模糊查询")
  @RequestMapping(value = "/findByConditions", method = RequestMethod.GET)
  public ResponseModel findByConditions(
      @ApiParam(name = "ruleName", value = "名称") String ruleName,
      @ApiParam(name = "ruleCode", value = "编码") String ruleCode,
      @ApiParam(name = "ruleType", value = "类型") String ruleType,
      @ApiParam(name = "language", value = "语言") String language,
      @PageableDefault(value = 50) Pageable pageable) {
    try {
      Page<CodeRuleEntity> page =
          this.codeRuleService.findByConditions(
              pageable, ruleName, ruleCode, ruleType, language);
      return this.buildHttpResultW(page, new String[] {""});
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
