package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.service.DynamicTaskSchedulerLogService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * 动态调用日志业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dynamicTaskLogs")
public class DynamicTaskSchedulerLogController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTaskSchedulerLogController.class);
  
  @Autowired
  private DynamicTaskSchedulerLogService dynamicTaskSchedulerLogService;
  
  /**
   * 按照关联的 对应的动态日志进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param dynamicTaskScheduler 关联的 对应的动态日志
   */
  @ApiOperation(value = "按照关联的 对应的动态日志进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsByDynamicTaskScheduler")
  public ResponseModel findDetailsByDynamicTaskScheduler(@RequestParam("dynamicTaskScheduler") @ApiParam("关联的 对应的动态日志") String dynamicTaskScheduler) {
    try { 
      Set<DynamicTaskSchedulerLogEntity> result = this.dynamicTaskSchedulerLogService.findDetailsByDynamicTaskScheduler(dynamicTaskScheduler); 
      return this.buildHttpResultW(result, "dynamicTaskScheduler");
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsById")
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      DynamicTaskSchedulerLogEntity result = this.dynamicTaskSchedulerLogService.findDetailsById(id); 
      return this.buildHttpResultW(result, "dynamicTaskScheduler");
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  
  /**
   * 该方法用于按照分页标准，对动态任务日志列表进行查询，并按照开始执行时间进行倒序排列
   * @param pageable 分页信息
   * @param taskId 任务ID编号（必须传入）
   * @param success 是否执行成功
   * @param logtime 执行日志的开始执行时间
   */
  @ApiOperation(value = "该方法用于按照分页标准，对动态任务日志列表进行查询，并按照开始执行时间进行倒序排列")
  @GetMapping("/findByConditions")
  public ResponseModel findByConditions(@PageableDefault(value = 50) @ApiParam(name = "pageable", value = "分页参数，当指定page时为查询当前页码（页码从0开始）；当指定size时，为指定每页大小，默认为50")  Pageable pageable 
                                                       ,@RequestParam(name="taskId" , required=true) @ApiParam(name = "taskId", value = "任务ID编号（必须传入）" , required=true) String taskId 
                                                       ,@RequestParam(name="success" , required=false) @ApiParam(name = "success", value = "是否执行成功" , required=false) Boolean success 
                                                       ,@RequestParam(name="logtime" , required=false) @ApiParam(name = "logtime", value = "执行日志的开始执行时间" , required=false) String logtime) {
    try {
      Page<DynamicTaskSchedulerLogEntity> results = this.dynamicTaskSchedulerLogService.findByConditions(pageable, taskId, success, logtime);
      return this.buildHttpResultW(results);
    } catch(Exception e) {
      return buildHttpResultForException(e);
    }
  }
} 
