package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.model.ResponseCode;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.saturn.model.PersistentClass;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * @author yinwenjie
 */
@RestController
@RequestMapping(value="/v1/nebula/static")
public class NebulaStaticPersistentController extends BaseController {
  
  @Autowired
  private NebulaStaticPersistentService nebulaStaticPersistentService;
  
  private static final Logger LOGGER = LoggerFactory.getLogger(NebulaStaticPersistentController.class);
  
  @ApiOperation(value = "查询系统中目前所有可用的静态模型信息，但是只包括静态模型本身的描述，不包括模型的一般属性描述和关联属性描述")
  @RequestMapping(value = "/findAllPersistentClasses", method = RequestMethod.GET)
  public ResponseModel findAllPersistentClasses() {
    try {
      List<PersistentClass> results = nebulaStaticPersistentService.findAllPersistentClasses();
      return buildResponse(results);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  private ResponseModel buildResponse(List<PersistentClass> results) {
    ResponseModel responseModel = new ResponseModel();
    responseModel.setData(results);
    responseModel.setResponseCode(ResponseCode.E0);
    responseModel.setSuccess(true);
    responseModel.setTimestamp(new Date().getTime());
    return responseModel;
  }
  
  @ApiOperation(value = "当前接口用于查询系统中目前所有可用的主静态模型信息，但是只包括静态模型本身的描述，不包括模型的一般属性描述和关联属性描述")
  @RequestMapping(value = "/findAllMainPersistentClasses", method = RequestMethod.GET)
  public ResponseModel findAllMainPersistentClasses() {
    try {
      List<PersistentClass> results = nebulaStaticPersistentService.findAllMainPersistentClasses();
      return buildResponse(results);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "通过指定的静态模型完整类名，获得这个静态模型在Saturn扫描组件中的一般属性、关联属性、自定义查询等信息")
  @RequestMapping(value = "/findByPersistentClass", method = RequestMethod.GET)
  public ResponseModel findByPersistentClass(@ApiParam(name = "className", value = "指定的静态模型完整类名") @RequestParam("className") String className) {
    try {
      PersistentClass result = nebulaStaticPersistentService.findByPersistentClass(className);
      ResponseModel responseModel = new ResponseModel();
      responseModel.setData(result);
      responseModel.setResponseCode(ResponseCode.E0);
      responseModel.setSuccess(true);
      responseModel.setTimestamp(new Date().getTime());
      return responseModel;
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
}
