package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Api(value = "StaticFormProxyController",tags="向外界暴露的服务源接口信息")
@RestController
@RequestMapping("/v1/nebula/servicableMethods")
public class StaticFormProxyController extends BaseController {
  @Autowired
  private ServicableMethodService servicableMethodService;
  private static final String[] EMPTY_STRING_ARR = new String[] {};
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(StaticFormProxyController.class); 
  
  @ApiOperation(value = "根据所暴露的服务源，用动态代理的方式调用接口，该功能会使用缓存机制", 
      notes = "该方法必须包含serviceName的值。model参数包含4部分：serviceName服务名(必传)，params是k-v结构的，customData也是k-v结构，formData是表单数据。")
  @ApiImplicitParams({
    @ApiImplicitParam(name = "model", value = "封装的传入参数（serviceName必传）", required = true)
  })
  @PostMapping("/servicableMethodInvoke")
  public ResponseModel invoke(@RequestBody InputParamsModel model) {
    try {
      // 对服务源信息进行校验
      Validate.notNull(model, "未接收到任何数据，请检查!!");
      Validate.notBlank(model.getServiceName(), "服务源名称不能为空，请检查!!");
      ServicableMethodEntity entity = servicableMethodService.findDetailsByName(model.getServiceName());
      Validate.notNull(entity,"根据服务名%s，没有查询到服务的相关信息，请检查!!" , model.getServiceName());
      // 构建调用器，并进行调用
      Object result = null;
      Map<String, Object> params = new HashMap<>();
      params.put(InputParamsModel.class.getName() , model);
      if(StringUtils.equals(entity.getUsedScope(), "WRITE")) {
        result = this.servicableMethodService.writeInvoke(params);
      } else {
        result = this.servicableMethodService.readInvoke(params);
      }
      // 对结果进行白名单过滤处理并返回统一数据结构结果
      if(result == null) {
        return buildHttpResult();
      } else if(Iterable.class.isAssignableFrom(result.getClass())) {
        Iterable<?> iterable = (Iterable<?>) result;
        return buildHttpResultW(iterable , StringUtils.isBlank(entity.getReturnPropertiesFilter()) ? EMPTY_STRING_ARR : entity.getReturnPropertiesFilter().split(","));
      } else {
        return buildHttpResultW(result , StringUtils.isBlank(entity.getReturnPropertiesFilter()) ? EMPTY_STRING_ARR : entity.getReturnPropertiesFilter().split(","));
      }
    } catch (Exception e) {
      LOGGER.error(e.getMessage(),e);
      return buildHttpResultForException(e);
    }
  }
}
