package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.SystemThemeEntity;
import com.bizunited.platform.core.service.SystemThemeService;
import com.bizunited.platform.rbac.server.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.security.Principal;

@Api(value = "SystemThemeController")
@RestController
@RequestMapping("/v1/nebula/theme")
public class SystemThemeController extends BaseController{
  /**
   * 日志
   * */
  private static final Logger LOGGER = LoggerFactory.getLogger(SystemThemeController.class);

  private static final String LOCK_THEME = "theme";

  @Autowired
  private SystemThemeService systemThemeService;
  @Autowired
  private RedisMutexService redisMutexService;



  @ApiOperation(value = "系统主题管理时，上传logo并保存(更新)主题")
  @RequestMapping(value = "/uploadLogo",method = RequestMethod.POST)
  public ResponseModel uploadLogo(@RequestParam("file") @ApiParam(name="file" , value="文件内容")MultipartFile file){
    try {
      Principal opUser = this.getPrincipal();
      OrdinaryFileEntity theme = systemThemeService.uploadLogo(file,opUser);
      return this.buildHttpResultW(theme);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  @ApiOperation(value = "系统主题管理时，保存(更新)主题")
  @RequestMapping(value = "",method = RequestMethod.POST)
  public ResponseModel save(@RequestBody @ApiParam(name="jsonTheme" , value="系统主题json格式数据")JSONObject jsonTheme){
    try {
      redisMutexService.lock(LOCK_THEME);
      Principal opUser = this.getPrincipal();
      SystemThemeEntity theme = systemThemeService.save(jsonTheme,opUser);
      return this.buildHttpResultW(theme);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }finally {
      redisMutexService.unlock(LOCK_THEME);
    }
  }

  @ApiOperation(value = "系统主题管理时，根据用户信息，加载主题")
  @RequestMapping(value = "/findTheme",method = RequestMethod.GET)
  public ResponseModel findTheme(){
    try {
      JSONObject theme = systemThemeService.findTheme();
      return this.buildHttpResultW(theme);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

}
