package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalRelationService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * 横向权限选定的权限关系集
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewAuthHorizontalRelations")
public class DataViewAuthHorizontalRelationController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthHorizontalRelationController.class);
  
  @Autowired
  private DataViewAuthHorizontalRelationService dataViewAuthHorizontalRelationService;


  /**
   * 按照关联的 横向数据权限进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param authHorizontal 关联的 横向数据权限
   */
  @ApiOperation(value = "按照关联的 横向数据权限进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByAuthHorizontal" , method={RequestMethod.GET})
  public ResponseModel findDetailsByAuthHorizontal(@RequestParam("authHorizontal") @ApiParam("关联的 横向数据权限") String authHorizontal) {
    try { 
      Set<DataViewAuthHorizontalRelationEntity> result = this.dataViewAuthHorizontalRelationService.findDetailsByAuthHorizontal(authHorizontal);
      return this.buildHttpResultW(result, "authHorizontal");
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      DataViewAuthHorizontalRelationEntity result = this.dataViewAuthHorizontalRelationService.findDetailsById(id);
      return this.buildHttpResultW(result, "authHorizontal");
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
} 
