package com.bizunited.platform.core.controller.vcode;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.vcode.ValidateCodeService;
import com.bizunited.platform.rbac.server.service.vcode.ValidateCodeType;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 和验证码有关的http层服务，由该类进行实现
 * @author yinwenjie
 */
@RestController
@RequestMapping("/v1/nebula/validateCodes")
public class ValidateCodeController extends BaseController {
  @Autowired
  private ValidateCodeService validateCodeService;
  
  @ApiOperation(value = "使用业务系统定义的信息发送途径，将生成的验证码发送出去（一次发送一个手机号），但不会通过本次http请求返回给请求者" ,
      notes = "指定的请求回话在60秒内只能发送一次验证码发送申请——无论手机号如何变；另外，生成的验证码从它生成点开始计算，它的有效期为五分钟，除非被主动覆盖！！")
  @PostMapping("")
  public ResponseModel send(HttpServletRequest request , 
                            @RequestParam(name = "phoneNumber") @ApiParam(name = "phoneNumber", value = "接收验证码的手机号") String phoneNumber) {
    try {
      HttpSession session = request.getSession();
      String userid = session.getId();
      // 默认验证码使用6位，纯数字进行生成和发送
      this.validateCodeService.send(phoneNumber, userid, "login", 6, ValidateCodeType.NUMERICAL, 300000);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      return this.buildHttpResultForException(e);
    }
  }
}