package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

/**
 * CodeRuleEntity 编码生成规则
 * @description:
 * @author: yanwe
 * @date: 12/Jun/2019 14:38
 */
@ApiModel(value = "CodeRuleEntity", description = "编码生成规则实体")
@Entity
@Table(name = "engine_code_rule")
@org.hibernate.annotations.Table(appliesTo = "engine_code_rule" , comment = "编码生成规则实体")
public class CodeRuleEntity extends UuidOpEntity {
  private static final long serialVersionUID = -3420085149244763883L;

  /** 编码生成规则的名称. * */
  @Column(name = "rule_name", length = 64, nullable = false, unique = true , columnDefinition = "varchar(64) COMMENT '编码生成规则的名称'")
  @ApiModelProperty(name = "ruleName", value = "编码生成规则名称", required = true)
  @SaturnColumn(description = "编码生成规则名称")
  private String ruleName;

  /** 编码生成规则的编号. * */
  @Column(name = "rule_code", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '编码生成规则的编号'")
  @ApiModelProperty(name = "ruleCode", value = "编码生成规则编号", required = true)
  @SaturnColumn(description = "编码生成规则编号")
  private String ruleCode;

  /** 编码生成规则的类别. * */
  @Column(name = "rule_type", length = 64, columnDefinition = "varchar(64)  COMMENT '编码生成规则的类别'")
  @ApiModelProperty(name = "ruleType", value = "编码生成规则类别")
  @SaturnColumn(description = "编码生成规则类别")
  private String ruleType;

  /** 编码生成规则的脚本语言. * */
  @Column(name = "language", length = 64, columnDefinition = "varchar(64)  COMMENT '编码生成规则的脚本语言'")
  @ApiModelProperty(name = "language", value = "编码生成规则脚本语言")
  @SaturnColumn(description = "编码生成规则脚本语言")
  private String language;

  /** 编码生成规则的说明. * */
  @Column(name = "description", length = 255, columnDefinition = "varchar(255)  COMMENT '编码生成规则的说明'")
  @ApiModelProperty(name = "description", value = "编码生成规则说明")
  @SaturnColumn(description = "编码生成规则说明")
  private String description;

  @OneToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "script_id", nullable = true, columnDefinition = "varchar(255)  COMMENT '编码生成规则的脚本实体'")
  @SaturnColumn(description = "编码生成规则的脚本实体")
  private ScriptEntity script;

  public String getRuleName() {
    return ruleName;
  }

  public void setRuleName(String ruleName) {
    this.ruleName = ruleName;
  }

  public String getRuleCode() {
    return ruleCode;
  }

  public void setRuleCode(String ruleCode) {
    this.ruleCode = ruleCode;
  }

  public String getRuleType() {
    return ruleType;
  }

  public void setRuleType(String ruleType) {
    this.ruleType = ruleType;
  }

  public String getLanguage() {
    return language;
  }

  public void setLanguage(String language) {
    this.language = language;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ScriptEntity getScript() {
    return script;
  }

  public void setScript(ScriptEntity script) {
    this.script = script;
  }
}
