package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import org.hibernate.annotations.OrderBy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * 数据视图之纵向数据权限信息
 */
@Entity
@Table(name="engine_dataview_auth_vertical",indexes={@Index(columnList="data_view")})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth_vertical" , comment = "数据视图之纵向数据权限信息")
public class DataViewAuthVerticalEntity extends UuidEntity{
  private static final long serialVersionUID = 1L;
  /**
   * 指定的字段
   * 注：当paramSourceType=1时，必须指定该字段
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="field" , nullable=true, columnDefinition = "varchar(255) COMMENT '指定的用户权限筛选字段，当paramSourceType=1时，必须指定该字段'")
  @SaturnColumn(description="指定的用户权限筛选字段")
  private DataViewFieldEntity field;

  /**
   * 权限类型
   * 1、用户
   * 2.角色
   * 3.岗位
   * 4.用户组
   * 5.组织机构
   */
  @Column(name="auth_type" , nullable=false , columnDefinition = "int(11) COMMENT '权限类型 1、用户 2.角色 3.岗位 4.用户组 5.组织机构'")
  @SaturnColumn(description="权限类型")
  private Integer authType;
  /**
   * 操作符类型
   */
  @Column(name="oprt_type" , length=32,nullable=false , columnDefinition = "varchar(32) COMMENT '操作符类型'" )
  @SaturnColumn(description="操作符类型")
  private String oprtType;
  /**
   * 参数来源类型：<br>
   * 2、固定值
   */
  @Column(name="param_source_type" , nullable=false , columnDefinition = "int(11) COMMENT '参数来源类型：2、固定值（暂时只有一个）'")
  @SaturnColumn(description="参数来源类型")
  private Integer paramSourceType = 2;
  /**
   * 需要显示的字段集
   */
  @ManyToMany(fetch=FetchType.LAZY , targetEntity = DataViewFieldEntity.class)
  @JoinTable(name = "engine_dataview_auth_field_mapping", joinColumns = {@JoinColumn(name = "auth_vertical_id")}, inverseJoinColumns = {@JoinColumn(name = "field_id")})
  @SaturnColumn(description="需要显示的字段集")
  private Set<DataViewFieldEntity> displayFields;
  /**
   * 纵向数据权限信息指定的权限领域
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="authVertical")
  @SaturnColumn(description="权限领域")
  @OrderBy(clause = "sortIndex")
  private Set<DataViewAuthVerticalRelationEntity> authRelations;

  /**
   * 排序字段
   */
  @Column(name="sort_index" , nullable=false , columnDefinition = "int(11) COMMENT '排序字段'")
  @SaturnColumn(description="纵向数据权限排序")
  private Integer sortIndex;

  /**
   * 对应的数据视图
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="data_view" , nullable=false , columnDefinition = "varchar(255) COMMENT '横向数据权限'")
  @SaturnColumn(description="对应的视图")
  private DataViewEntity dataView;

  public Set<DataViewFieldEntity> getDisplayFields() {
    return displayFields;
  }

  public void setDisplayFields(Set<DataViewFieldEntity> displayFields) {
    this.displayFields = displayFields;
  }

  public Integer getAuthType() {
    return authType;
  }

  public void setAuthType(Integer authType) {
    this.authType = authType;
  }

  public DataViewEntity getDataView() {
    return dataView;
  }

  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }

  public Set<DataViewAuthVerticalRelationEntity> getAuthRelations() {
    return authRelations;
  }

  public void setAuthRelations(Set<DataViewAuthVerticalRelationEntity> authRelations) {
    this.authRelations = authRelations;
  }

  public String getOprtType() {
    return oprtType;
  }

  public void setOprtType(String oprtType) {
    this.oprtType = oprtType;
  }

  public Integer getParamSourceType() {
    return paramSourceType;
  }

  public void setParamSourceType(Integer paramSourceType) {
    this.paramSourceType = paramSourceType;
  }

  public DataViewFieldEntity getField() {
    return field;
  }

  public void setField(DataViewFieldEntity field) {
    this.field = field;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
}
