package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;


/**
 * 纵向权限之权限领域
 */
@Entity
@Table(name="engine_dataview_auth_vertical_relation", uniqueConstraints = {@UniqueConstraint(columnNames = {"auth_vertical", "auth_relation_id"})})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth_vertical_relation" , comment = "纵向权限之权限领域")
public class DataViewAuthVerticalRelationEntity extends UuidEntity{
  private static final long serialVersionUID = 1L;
  /**
   * 纵向数据权限
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="auth_vertical" , nullable=false , columnDefinition = "varchar(255) COMMENT '纵向数据权限'")
  @SaturnColumn(description="纵向数据权限")
  private DataViewAuthVerticalEntity authVertical;
  /**
   * 权限关系集
   */
  @Column(name="auth_relation_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '权限关系集'")
  @SaturnColumn(description="纵向权限领域")
  private String authRelationIds;
  /**
   * 排序字段
   */
  @Column(name="sort_index" , nullable=false , columnDefinition = "int(11) COMMENT '排序字段'")
  @SaturnColumn(description="纵向权限排序")
  private Integer sortIndex;

  /**
   * 横向权限领域数据
   */
  @Transient
  @SaturnColumn(description="横向权限领域数据")
  private UuidEntity relation;

  public DataViewAuthVerticalEntity getAuthVertical() {
    return authVertical;
  }

  public void setAuthVertical(DataViewAuthVerticalEntity authVertical) {
    this.authVertical = authVertical;
  }

  public String getAuthRelationIds() {
    return authRelationIds;
  }

  public void setAuthRelationIds(String authRelationIds) {
    this.authRelationIds = authRelationIds;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public UuidEntity getRelation() {
    return relation;
  }

  public void setRelation(UuidEntity relation) {
    this.relation = relation;
  }
}
