package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Set;

/**
 * DictCategoryRepository
 * @description: 字典分类
 * @author: yanwe
 * @date: 11/Jun/2019 16:47
 */
@ApiModel(value = "DictCategoryRepository", description = "字典分类")
@Entity
@Table(name = "engine_category_dict")
@org.hibernate.annotations.Table(appliesTo = "engine_category_dict" , comment = "字典分类")
public class DictCategoryEntity extends UuidOpEntity {

  private static final long serialVersionUID = 8118797910731290828L;
  /** 字典分类编码 * */
  @Column(name = "cate_code", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '字典分类编码'")
  @ApiModelProperty(name = "cateCode", value = "字典分类编码", required = true)
  @SaturnColumn(description = "字典分类编码")
  private String cateCode;
  /** 字典分类名称. * */
  @Column(name = "cate_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '字典分类名称'")
  @ApiModelProperty(name = "cateName", value = "字典分类名称", required = true)
  @SaturnColumn(description = "字典分类名称")
  private String cateName;
  /** 字典分类描述. * */
  @Column(name = "cate_desc", length = 64, columnDefinition = "varchar(64) COMMENT '字典分类描述'")
  @ApiModelProperty(name = "cateDesc", value = "字典分类描述")
  @SaturnColumn(description = "字典分类描述")
  private String cateDesc;
  /** 父级分组 */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "parent_id", columnDefinition = "varchar(255) COMMENT '父级分组'")
  @SaturnColumn(description = "父级分类")
  private DictCategoryEntity parentCategory;
  /** 子级分组 */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parentCategory")
  @SaturnColumn(description = "子级组织")
  @OrderBy("createTime")
  private Set<DictCategoryEntity> childCategory;
  /** 该分组下所有字典 */
  @OrderBy("createTime")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "category")
  @SaturnColumn(description = "该分组下所有字典")
  private Set<DictEntity> dicts;
  public String getCateCode() {
    return cateCode;
  }
  public void setCateCode(String cateCode) {
    this.cateCode = cateCode;
  }
  public String getCateDesc() {
    return cateDesc;
  }
  public void setCateDesc(String cateDesc) {
    this.cateDesc = cateDesc;
  }
  public DictCategoryEntity getParentCategory() {
    return parentCategory;
  }
  public void setParentCategory(DictCategoryEntity parentCategory) {
    this.parentCategory = parentCategory;
  }
  public Set<DictCategoryEntity> getChildCategory() {
    return childCategory;
  }
  public void setChildCategory(Set<DictCategoryEntity> childCategory) {
    this.childCategory = childCategory;
  }
  public Set<DictEntity> getDicts() {
    return dicts;
  }
  public void setDicts(Set<DictEntity> dicts) {
    this.dicts = dicts;
  }

  public String getCateName() {
    return cateName;
  }

  public void setCateName(String cateName) {
    this.cateName = cateName;
  }
}
