package com.bizunited.platform.core.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;

@ApiModel(value = "DynamicTaskSchedulerEntity", description = "技术中台，周期性或一次性动态任务")
@Entity
@Table(name = "engine_dynamic_task" , indexes = {
  @Index(columnList = "script_name"),
  @Index(columnList = "application_name,task_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "engine_dynamic_task" , comment = "技术中台，周期性或一次性动态任务")
public class DynamicTaskSchedulerEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 9187377641504269587L;
  /**
   * 任务唯一编号（只能由英文、数字、下杠构成）
   */
  @Column(name="task_code" , length = 255 , nullable = false , columnDefinition = "varchar(255) COMMENT '任务唯一编号（只能由英文、数字、下杠构成）'")
  @SaturnColumn(description = "任务唯一编号（只能由英文、数字、下杠构成）")
  private String taskCode;
  /**
   * 任务中文说明
   */
  @Column(name="task_desc" , nullable = false, columnDefinition = "varchar(255) COMMENT '任务中文说明'")
  @SaturnColumn(description = "任务中文说明")
  private String taskDesc;
  /**
   * 由于多个微服务中心可能共享一个数据库
   * 那么就存在A服务更新定时任务时，将B服务中心配置的定时任务误操作。
   * 为了避免这个情况，这里可以有扫描程序设定服务名（必须有）
   */
  @Column(name="application_name" , nullable = true, columnDefinition = "varchar(255) COMMENT '应用程序名'")
  @SaturnColumn(description = "应用程序名")
  private String applicationName = "default";
  /**
   * 定时器任务内容的执行方式:</br>
   * 1：groovy脚本执行器</br>
   * 2：基于注解的Java method
   */
  @Column(name="invoke_type" , nullable = false, columnDefinition = "int(11) COMMENT '定时器任务内容的执行方式：1：groovy脚本执行器；2：基于注解的Java method'")
  @SaturnColumn(description = "定时器任务内容的执行方式")
  private Integer invokeType;
  /**
   * 任务类型：1、一次性执行；2：周期性执行
   */
  @Column(name="task_type" , nullable = false, columnDefinition = "int(11) COMMENT '任务类型：1、一次性执行；2：周期性执行'")
  @SaturnColumn(description = "任务类型")
  private Integer taskType = 2;
  /**
   * 任务状态：0：无效任务；1、有效任务
   */
  @Column(name="t_status" , nullable = false, columnDefinition = "int(11) COMMENT '任务状态：0：无效任务；1、有效任务'")
  @SaturnColumn(description = "任务状态")
  private Integer tstatus = 0;
  /**
   * 工作状态：0：要求运行， 1：要求停止，2：已运行
   */
  @Column(name="working_status" , nullable = false, columnDefinition = "int(11) COMMENT '工作状态：0：要求运行， 1：要求停止，2：已运行'")
  @SaturnColumn(description = "工作状态：0：要求运行， 1：要求停止，2：已运行")
  private Integer workingStatus = 0;
  /**
   * 一次性任务的执行时间点
   */
  @Column(name="execute_point" , nullable = true, columnDefinition = "datetime COMMENT '一次性任务的执行时间点'")
  @SaturnColumn(description = "一次性任务的执行时间点")
  private Date executePoint;
  /**
   * 周期性任务执行表单式，满足corn表达式
   */
  @Column(name="execute_expression" , length = 32 , nullable = true, columnDefinition = "varchar(32) COMMENT '周期性任务执行表单式，满足corn表达式'")
  @SaturnColumn(description = "周期性任务执行表单式，满足corn表达式")
  private String executeExpression;
  /**
   * 周期性表单时的中文解析
   */
  @Column(name="expression_desc" , nullable = true, columnDefinition = "varchar(255) COMMENT '周期性表达式的中文'")
  @SaturnColumn(description = "周期性表达式的中文")
  private String expressionDesc;
  /**
   * 执行的groovy脚本名（唯一的脚本名），可以是空字符串
   */
  @Column(name = "script_name" , nullable = false, columnDefinition = "varchar(255) COMMENT '执行的groovy脚本名（唯一的脚本名）'")
  @SaturnColumn(description = "执行的groovy脚本名（唯一的脚本名）")
  private String scriptName;
  /**
   * 执行基于注解的java method时，带有包名、类名的完整方法名
   */
  @Column(name = "invoke_method" , length = 255 , nullable = false, columnDefinition = "varchar(255) COMMENT '执行基于注解的java method时的短方法名，只包括方法名，不包括类名'")
  @SaturnColumn(description = "执行基于注解的java method时的短方法名，只包括方法名，不包括类名")
  private String invokeMethod;
  /**
   * 执行基于注解的java method时的对应的spring bean信息
   */
  @Column(name = "invoke_bean_name" , length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '执行基于注解的java method时的对应的spring bean信息'")
  @SaturnColumn(description = "执行基于注解的java method时的对应的spring bean信息")
  private String invokeBeanName;
  /**
   * 执行基于注解的java method中是否要求InvokeProxyContext作为入参
   */
  @Column(name = "proxy_context_param" , nullable = false, columnDefinition = "bit(1) COMMENT '执行基于注解的java method中是否要求InvokeProxyContext作为入参'")
  @SaturnColumn(description = "执行基于注解的java method中是否要求InvokeProxyContext作为入参")
  private boolean proxyContextParam = false;
  /**
   * 任务有效期
   */
  @Column(name = "validity_time" , nullable = true, columnDefinition = "datetime COMMENT '任务有效期'")
  @SaturnColumn(description = "任务有效期")
  private Date validityTime;
  
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getTaskDesc() {
    return taskDesc;
  }
  public void setTaskDesc(String taskDesc) {
    this.taskDesc = taskDesc;
  }
  public Integer getTaskType() {
    return taskType;
  }
  public void setTaskType(Integer taskType) {
    this.taskType = taskType;
  }
  public Date getExecutePoint() {
    return executePoint;
  }
  public void setExecutePoint(Date executePoint) {
    this.executePoint = executePoint;
  }
  public String getExecuteExpression() {
    return executeExpression;
  }
  public void setExecuteExpression(String executeExpression) {
    this.executeExpression = executeExpression;
  }
  public String getExpressionDesc() {
    return expressionDesc;
  }
  public void setExpressionDesc(String expressionDesc) {
    this.expressionDesc = expressionDesc;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  } 
  public Integer getWorkingStatus() {
    return workingStatus;
  }
  public void setWorkingStatus(Integer workingStatus) {
    this.workingStatus = workingStatus;
  }
  public Date getValidityTime() {
    return validityTime;
  }
  public void setValidityTime(Date validityTime) {
    this.validityTime = validityTime;
  }
  public Integer getInvokeType() {
    return invokeType;
  }
  public void setInvokeType(Integer invokeType) {
    this.invokeType = invokeType;
  }
  public String getScriptName() {
    return scriptName;
  }
  public void setScriptName(String scriptName) {
    this.scriptName = scriptName;
  }
  public String getInvokeMethod() {
    return invokeMethod;
  }
  public void setInvokeMethod(String invokeMethod) {
    this.invokeMethod = invokeMethod;
  }
  public String getInvokeBeanName() {
    return invokeBeanName;
  }
  public void setInvokeBeanName(String invokeBeanName) {
    this.invokeBeanName = invokeBeanName;
  }
  public boolean getProxyContextParam() {
    return proxyContextParam;
  }
  public void setProxyContextParam(boolean proxyContextParam) {
    this.proxyContextParam = proxyContextParam;
  }
  public String getApplicationName() {
    return applicationName;
  }
  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  } 
}