package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * EnvironmentVariableEntity 前端环境变量存储
 *
 * @description:
 * @author: yanwe
 * @date: 15/May/2019 14:23
 */
@ApiModel("环境变量存储")
@Entity
@Table(name = "engine_env_var")
@org.hibernate.annotations.Table(appliesTo = "engine_env_var" , comment = "环境变量存储")
public class EnvironmentVariableEntity extends UuidEntity {

  private static final long serialVersionUID = 3791121872843792543L;

  /** 参数编码 */
  @ApiModelProperty(name = "paramCode", value = "参数编码，必填，唯一", required = true)
  @Column(name = "param_code", nullable = false, unique = true , columnDefinition = "varchar(255) COMMENT '参数编码'")
  @SaturnColumn(description = "参数编码")
  private String paramCode;

  /** 参数键 */
  @ApiModelProperty(name = "paramKey", value = "参数key，必填，唯一", required = true)
  @Column(name = "param_key", nullable = false, unique = true, columnDefinition = "varchar(255) COMMENT '参数键'")
  @SaturnColumn(description = "键")
  private String paramKey;

  /** 参数值 */
  @ApiModelProperty(name = "paramValue", value = "参数value，必填", required = true)
  @Column(name = "param_value",  nullable = false, columnDefinition = "varchar(255) COMMENT '参数值'")
  @SaturnColumn(description = "值")
  private String paramValue;

  /** 参数类型 */
  @ApiModelProperty(name = "paramType", value = "参数类型，必填", required = true)
  @Column(name = "param_type",  nullable = false, columnDefinition = "varchar(255) COMMENT '参数类型'")
  @SaturnColumn(description = "参数类型")
  private String paramType;

  /** 参数描述 */
  @ApiModelProperty(name = "paramDesc", value = "参数描述")
  @Column(name = "param_desc",  columnDefinition = "varchar(255) COMMENT '参数描述'")
  @SaturnColumn(description = "参数描述")
  private String paramDesc;

  /** 参数状态,0:启用，1：禁用 */
  @ApiModelProperty(name = "paramStatus", value = "参数状态,1:启用，0：禁用")
  @Column(name = "param_status", columnDefinition = "int(11) COMMENT '参数状态,0:启用，1：禁用'")
  @SaturnColumn(description = "参数状态,1:启用，0：禁用")
  private Integer paramStatus;

  /** 创建时间. * */
  @ApiModelProperty(name = "createDate", value = "创建时间，系统创建时间不必由前端传入，后端会在创建时自动填写", required = false)
  @Column(name = "create_date", nullable = false, columnDefinition = "datetime COMMENT '创建时间，系统创建时间不必由前端传入，后端会在创建时自动填写'")
  @SaturnColumn(description = "创建时间")
  private Date createDate = new Date();

  /** 最后更新时间 */
  @ApiModelProperty(name = "modifyDate", value = "最后更新时间")
  @Column(name = "modify_Date", columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyDate;

  /** 创建人 */
  @ApiModelProperty(name = "createUser", value = "创建人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "create_user", columnDefinition = "varchar(255) COMMENT '创建人'")
  @SaturnColumn(description = "创建人")
  private UserEntity createUser;

  /** 最后更新人 */
  @ApiModelProperty(name = "modifyUser", value = "最后更新人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "modify_user", columnDefinition = "varchar(255) COMMENT '最后更新人'")
  @SaturnColumn(description = "最后更新人")
  private UserEntity modifyUser;

  public String getParamCode() {
    return paramCode;
  }

  public void setParamCode(String paramCode) {
    this.paramCode = paramCode;
  }

  public String getParamKey() {
    return paramKey;
  }

  public void setParamKey(String paramKey) {
    this.paramKey = paramKey;
  }

  public String getParamValue() {
    return paramValue;
  }

  public void setParamValue(String paramValue) {
    this.paramValue = paramValue;
  }

  public String getParamType() {
    return paramType;
  }

  public void setParamType(String paramType) {
    this.paramType = paramType;
  }

  public String getParamDesc() {
    return paramDesc;
  }

  public void setParamDesc(String paramDesc) {
    this.paramDesc = paramDesc;
  }

  public Integer getParamStatus() {
    return paramStatus;
  }

  public void setParamStatus(Integer paramStatus) {
    this.paramStatus = paramStatus;
  }

  public Date getCreateDate() {
    return createDate;
  }

  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }

  public Date getModifyDate() {
    return modifyDate;
  }

  public void setModifyDate(Date modifyDate) {
    this.modifyDate = modifyDate;
  }

  public UserEntity getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserEntity createUser) {
    this.createUser = createUser;
  }

  public UserEntity getModifyUser() {
    return modifyUser;
  }

  public void setModifyUser(UserEntity modifyUser) {
    this.modifyUser = modifyUser;
  }
}
