package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * MigrateConfigAnalysisEntity
 *
 * @description:
 * @author: yanwe
 * @date: 03/Sep/2019 14:43
 */
@ApiModel(value = "MigrateConfigAnalysisEntity", description = "基础配置信息迁移预分析结果")
@Entity
@Table(name = "engine_form_migrate_config_analysis")
public class MigrateConfigAnalysisEntity extends UuidEntity {

  private static final long serialVersionUID = -378364074674210368L;

  /** 关联的迁移任务上传记录 */
  @ApiModelProperty(name = "migrateImportEntity", value = "关联的迁移任务上传记录")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "migrate_import_entity_id", columnDefinition = "varchar(255) COMMENT '编号'")
  @SaturnColumn(description = "关联的迁移任务上传记录")
  private MigrateImportEntity migrateImportEntity;

  /** 分析执行人 */
  @ApiModelProperty(name = "executor", value = "分析执行人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "executor", columnDefinition = "varchar(255) COMMENT '编号'")
  @SaturnColumn(description = "分析执行人")
  private UserEntity executor;

  /** 分析时间 */
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '分析时间'")
  @ApiModelProperty(name = "createTime", value = "分析时间", required = true)
  @SaturnColumn(description = "分析时间")
  private Date createTime = new Date();

  /** 数据视图总量 */
  @Column(name = "dataview_num", nullable = false, columnDefinition = "int(11) COMMENT '数据视图总量'")
  @SaturnColumn(description = "dataviewNum")
  @ApiModelProperty(name = "dataviewNum", value = "数据视图总量", required = true)
  private Integer dataviewNum = 0;

  /** 数据视图成功数量 */
  @Column(name = "dataview_create", nullable = false, columnDefinition = "int(11) COMMENT '数据视图成功数量'")
  @SaturnColumn(description = "dataviewCreate")
  @ApiModelProperty(name = "dataviewCreate", value = "数据视图成功数量", required = true)
  private Integer dataviewCreate = 0;

  /** 数据源总量 */
  @Column(name = "dataview_source_num", nullable = false, columnDefinition = "int(11) COMMENT '数据源总量'")
  @SaturnColumn(description = "dataviewSourceNum")
  @ApiModelProperty(name = "dataviewSourceNum", value = "数据源总量", required = true)
  private Integer dataviewSourceNum = 0;

  /** 数据源成功数量 */
  @Column(name = "dataview_source_create", nullable = false, columnDefinition = "int(11) COMMENT '数据源成功数量'")
  @SaturnColumn(description = "dataviewSourceCreate")
  @ApiModelProperty(name = "dataviewSourceCreate", value = "数据源成功数量", required = true)
  private Integer dataviewSourceCreate = 0;

  /** 数据分组总量 */
  @Column(name = "dataview_group_num", nullable = false, columnDefinition = "int(11) COMMENT '数据分组总量'")
  @SaturnColumn(description = "dataviewGroupNum")
  @ApiModelProperty(name = "dataviewGroupNum", value = "数据分组总量", required = true)
  private Integer dataviewGroupNum = 0;

  /** 数据分组成功数量 */
  @Column(name = "dataview_group_create", nullable = false, columnDefinition = "int(11) COMMENT '数据分组成功数量'")
  @SaturnColumn(description = "dataviewGroupCreate")
  @ApiModelProperty(name = "dataviewGroupCreate", value = "数据分组成功数量", required = true)
  private Integer dataviewGroupCreate = 0;

  /** 数据视图横向权限总量 */
  @Column(name = "dataview_auth_hor_num", nullable = false, columnDefinition = "int(11) COMMENT '数据视图横向权限总量'")
  @SaturnColumn(description = "dataviewAuthHorNum")
  @ApiModelProperty(name = "dataviewAuthHorNum", value = "数据视图横向权限总量", required = true)
  private Integer dataviewAuthHorNum = 0;

  /** 数据视图横向权限成功数量 */
  @Column(name = "dataview_auth_hor_create", nullable = false, columnDefinition = "int(11) COMMENT '数据视图横向权限成功数量'")
  @SaturnColumn(description = "dataviewAuthHorCreate")
  @ApiModelProperty(name = "dataviewAuthHorCreate", value = "数据视图横向权限成功数量", required = true)
  private Integer dataviewAuthHorCreate = 0;

  /** 数据视图纵向权限总量 */
  @Column(name = "dataview_auth_ver_num", nullable = false, columnDefinition = "int(11) COMMENT '数据视图纵向权限总量'")
  @SaturnColumn(description = "dataviewAuthVerNum")
  @ApiModelProperty(name = "dataviewAuthVerNum", value = "数据视图纵向权限总量", required = true)
  private Integer dataviewAuthVerNum = 0;

  /** 数据视图纵向权限成功数量 */
  @Column(name = "dataview_auth_ver_create", nullable = false, columnDefinition = "int(11) COMMENT '数据视图纵向权限成功数量'")
  @SaturnColumn(description = "dataviewAuthVerCreate")
  @ApiModelProperty(name = "dataviewAuthVerCreate", value = "数据视图纵向权限成功数量", required = true)
  private Integer dataviewAuthVerCreate = 0;

  /** 业务编码总数量 */
  @Column(name = "code_rule_num", nullable = false, columnDefinition = "int(11) COMMENT '业务编码总数量'")
  @SaturnColumn(description = "codeRuleNum")
  @ApiModelProperty(name = "codeRuleNum", value = "业务编码总数量", required = true)
  private Integer codeRuleNum = 0;

  /** 业务编码成功数量 */
  @Column(name = "code_rule_create", nullable = false, columnDefinition = "int(11) COMMENT '业务编码成功数量'")
  @SaturnColumn(description = "codeRuleCreate")
  @ApiModelProperty(name = "codeRuleCreate", value = "业务编码成功数量", required = true)
  private Integer codeRuleCreate = 0;

  /** 脚本总数量 */
  @Column(name = "script_num", nullable = false, columnDefinition = "int(11) COMMENT '脚本总数量'")
  @SaturnColumn(description = "scriptNum")
  @ApiModelProperty(name = "scriptNum", value = "脚本总数量", required = true)
  private Integer scriptNum = 0;

  /** 脚本成功数量 */
  @Column(name = "script_create", nullable = false, columnDefinition = "int(11) COMMENT '脚本成功数量'")
  @SaturnColumn(description = "scriptCreate")
  @ApiModelProperty(name = "scriptCreate", value = "脚本成功数量", required = true)
  private Integer scriptCreate = 0;

  /** 字典总数量 */
  @Column(name = "dict_num", nullable = false, columnDefinition = "int(11) COMMENT '字典总数量'")
  @SaturnColumn(description = "dictNum")
  @ApiModelProperty(name = "dictNum", value = "字典总数量", required = true)
  private Integer dictNum = 0;

  /** 字典成功数量 */
  @Column(name = "dict_create", nullable = false, columnDefinition = "int(11) COMMENT '字典成功数量'")
  @SaturnColumn(description = "dictCreate")
  @ApiModelProperty(name = "dictCreate", value = "字典成功数量", required = true)
  private Integer dictCreate = 0;

  /** 字典分组总数量 */
  @Column(name = "dict_cate_num", nullable = false, columnDefinition = "int(11) COMMENT '字典分组总数量'")
  @SaturnColumn(description = "dictCateNum")
  @ApiModelProperty(name = "dictCateNum", value = "字典总数量", required = true)
  private Integer dictCateNum = 0;

  /** 字典分组成功数量 */
  @Column(name = "dict_cate_create", nullable = false, columnDefinition = "int(11) COMMENT '字典分组成功数量'")
  @SaturnColumn(description = "dictCateCreate")
  @ApiModelProperty(name = "dictCateCreate", value = "字典成功数量", required = true)
  private Integer dictCateCreate = 0;

  /** 全局环境变量总数量 */
  @Column(name = "env_num", nullable = false, columnDefinition = "int(11) COMMENT '全局环境变量总数量'")
  @SaturnColumn(description = "envNum")
  @ApiModelProperty(name = "envNum", value = "全局环境变量总数量", required = true)
  private Integer envNum = 0;

  /** 全局环境变量成功数量 */
  @Column(name = "env_create", nullable = false, columnDefinition = "int(11) COMMENT '全局环境变量成功数量'")
  @SaturnColumn(description = "envCreate")
  @ApiModelProperty(name = "envCreate", value = "全局环境变量成功数量", required = true)
  private Integer envCreate = 0;

  /** 远端服务源总数量 */
  @Column(name = "remote_service_num", nullable = false, columnDefinition = "int(11) COMMENT '远端服务源总数量'")
  @SaturnColumn(description = "remoteServiceNum")
  @ApiModelProperty(name = "remoteServiceNum", value = "远端服务源总数量", required = true)
  private Integer remoteServiceNum = 0;

  /** 远端服务源成功数量 */
  @Column(name = "remote_service_create", nullable = false, columnDefinition = "int(11) COMMENT '远端服务源成功数量'")
  @SaturnColumn(description = "remoteServiceCreate")
  @ApiModelProperty(name = "remoteServiceCreate", value = "远端服务源成功数量", required = true)
  private Integer remoteServiceCreate = 0;

  /** 远端服务地址总数量 */
  @Column(name = "remote_address_num", nullable = false, columnDefinition = "int(11) COMMENT '远端服务地址总数量'")
  @SaturnColumn(description = "remoteAddressNum")
  @ApiModelProperty(name = "remoteAddressNum", value = "远端服务源总数量", required = true)
  private Integer remoteAddressNum = 0;

  /** 远端服务地址成功数量 */
  @Column(name = "remote_address_create", nullable = false, columnDefinition = "int(11) COMMENT '远端服务地址成功数量'")
  @SaturnColumn(description = "remoteAddressCreate")
  @ApiModelProperty(name = "remoteAddressCreate", value = "远端服务地址成功数量", required = true)
  private Integer remoteAddressCreate = 0;

  public MigrateImportEntity getMigrateImportEntity() {
    return migrateImportEntity;
  }

  public void setMigrateImportEntity(MigrateImportEntity migrateImportEntity) {
    this.migrateImportEntity = migrateImportEntity;
  }

  public UserEntity getExecutor() {
    return executor;
  }

  public void setExecutor(UserEntity executor) {
    this.executor = executor;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Integer getDataviewNum() {
    return dataviewNum;
  }

  public void setDataviewNum(Integer dataviewNum) {
    this.dataviewNum = dataviewNum;
  }

  public Integer getDataviewCreate() {
    return dataviewCreate;
  }

  public void setDataviewCreate(Integer dataviewCreate) {
    this.dataviewCreate = dataviewCreate;
  }

  public Integer getCodeRuleNum() {
    return codeRuleNum;
  }

  public void setCodeRuleNum(Integer codeRuleNum) {
    this.codeRuleNum = codeRuleNum;
  }

  public Integer getCodeRuleCreate() {
    return codeRuleCreate;
  }

  public void setCodeRuleCreate(Integer codeRuleCreate) {
    this.codeRuleCreate = codeRuleCreate;
  }

  public Integer getDictNum() {
    return dictNum;
  }

  public void setDictNum(Integer dictNum) {
    this.dictNum = dictNum;
  }

  public Integer getDictCreate() {
    return dictCreate;
  }

  public void setDictCreate(Integer dictCreate) {
    this.dictCreate = dictCreate;
  }

  public Integer getEnvNum() {
    return envNum;
  }

  public void setEnvNum(Integer envNum) {
    this.envNum = envNum;
  }

  public Integer getEnvCreate() {
    return envCreate;
  }

  public void setEnvCreate(Integer envCreate) {
    this.envCreate = envCreate;
  }

  public Integer getRemoteServiceNum() {
    return remoteServiceNum;
  }

  public void setRemoteServiceNum(Integer remoteServiceNum) {
    this.remoteServiceNum = remoteServiceNum;
  }

  public Integer getRemoteServiceCreate() {
    return remoteServiceCreate;
  }

  public void setRemoteServiceCreate(Integer remoteServiceCreate) {
    this.remoteServiceCreate = remoteServiceCreate;
  }

  public Integer getDataviewSourceNum() {
    return dataviewSourceNum;
  }

  public void setDataviewSourceNum(Integer dataviewSourceNum) {
    this.dataviewSourceNum = dataviewSourceNum;
  }

  public Integer getDataviewSourceCreate() {
    return dataviewSourceCreate;
  }

  public void setDataviewSourceCreate(Integer dataviewSourceCreate) {
    this.dataviewSourceCreate = dataviewSourceCreate;
  }

  public Integer getDataviewGroupNum() {
    return dataviewGroupNum;
  }

  public void setDataviewGroupNum(Integer dataviewGroupNum) {
    this.dataviewGroupNum = dataviewGroupNum;
  }

  public Integer getDataviewGroupCreate() {
    return dataviewGroupCreate;
  }

  public void setDataviewGroupCreate(Integer dataviewGroupCreate) {
    this.dataviewGroupCreate = dataviewGroupCreate;
  }

  public Integer getDataviewAuthHorNum() {
    return dataviewAuthHorNum;
  }

  public void setDataviewAuthHorNum(Integer dataviewAuthHorNum) {
    this.dataviewAuthHorNum = dataviewAuthHorNum;
  }

  public Integer getDataviewAuthHorCreate() {
    return dataviewAuthHorCreate;
  }

  public void setDataviewAuthHorCreate(Integer dataviewAuthHorCreate) {
    this.dataviewAuthHorCreate = dataviewAuthHorCreate;
  }

  public Integer getDataviewAuthVerNum() {
    return dataviewAuthVerNum;
  }

  public void setDataviewAuthVerNum(Integer dataviewAuthVerNum) {
    this.dataviewAuthVerNum = dataviewAuthVerNum;
  }

  public Integer getDataviewAuthVerCreate() {
    return dataviewAuthVerCreate;
  }

  public void setDataviewAuthVerCreate(Integer dataviewAuthVerCreate) {
    this.dataviewAuthVerCreate = dataviewAuthVerCreate;
  }

  public Integer getScriptNum() {
    return scriptNum;
  }

  public void setScriptNum(Integer scriptNum) {
    this.scriptNum = scriptNum;
  }

  public Integer getScriptCreate() {
    return scriptCreate;
  }

  public void setScriptCreate(Integer scriptCreate) {
    this.scriptCreate = scriptCreate;
  }

  public Integer getDictCateNum() {
    return dictCateNum;
  }

  public void setDictCateNum(Integer dictCateNum) {
    this.dictCateNum = dictCateNum;
  }

  public Integer getDictCateCreate() {
    return dictCateCreate;
  }

  public void setDictCateCreate(Integer dictCateCreate) {
    this.dictCateCreate = dictCateCreate;
  }

  public Integer getRemoteAddressNum() {
    return remoteAddressNum;
  }

  public void setRemoteAddressNum(Integer remoteAddressNum) {
    this.remoteAddressNum = remoteAddressNum;
  }

  public Integer getRemoteAddressCreate() {
    return remoteAddressCreate;
  }

  public void setRemoteAddressCreate(Integer remoteAddressCreate) {
    this.remoteAddressCreate = remoteAddressCreate;
  }
}
