package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 该实体记录业务系统中所有需要使用鉴权登录的用户信息。例如后台管理员用户。通过不同的角色信息，对这些用户进行区别
 * @author yinwenjie
 */
@ApiModel(value = "UserEntity" , description="一个拥有权限信息的业务系统用户定义")
@Entity
@Table(name = "engine_user")
@org.hibernate.annotations.Table(appliesTo = "engine_user" , comment = "一个拥有权限信息的业务系统用户定义")
public class UserEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 318381684938863952L;
  
  @ApiModelProperty(name="userName" , value="人员姓名" , required=true)
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '人员姓名'")
  @SaturnColumn(description="人员姓名")
  private String userName;
  
  @ApiModelProperty(name="account" , value="用户账号登录信息" , required=true)
  @Column(name = "user_account", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '用户账号登录信息'")
  @SaturnColumn(description="用户账号登录信息")
  private String account;
  
  @ApiModelProperty(name="phone" , value="人员主要联系电话(也可能会使用该信息登录)" , required=false)
  @Column(name = "user_phone", length = 64, nullable = true, unique = true, columnDefinition = "varchar(64) COMMENT '人员主要联系电话(也可能会使用该信息登录)'")
  @SaturnColumn(description="人员主要联系电话")
  private String phone = "";
  
  @ApiModelProperty(name="password" , value="用户账号密码信息（经过加密的）" , required=true)
  @Column(name = "user_password", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '用户账号密码信息（经过加密的）'")
  @SaturnColumn(description="用户账号密码信息")
  private String password;
  
  @ApiModelProperty(name="createTime" , value="创建时间" , required=false)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime=new Date();
  
  @ApiModelProperty(name="entryTime" , value="入职时间" , required=false)
  @Column(name = "entry_time", nullable = true, columnDefinition = "datetime COMMENT '入职时间'")
  @SaturnColumn(description="入职时间")
  private Date entryTime=new Date();
  
  @ApiModelProperty(name="lastloginTime" , value="最后一次登录时间" , required=false)
  @Column(name = "lastlogin_time", nullable = true, columnDefinition = "datetime COMMENT '最后一次登录时间'")
  @SaturnColumn(description="最后一次登录时间")
  private Date lastloginTime=new Date();
  
  @ApiModelProperty(name="useStatus" , value="用户账号状态 1：正常，其它值（0）不正常" , required=false)
  @Column(name = "use_status", nullable = false, columnDefinition = "int(11) COMMENT '用户账号状态 1：正常，其它值（0）不正常'")
  @SaturnColumn(description="用户账号状态")
  private Integer useStatus = 1;
  
  /** 角色和人员相关的. **/
  @ApiModelProperty(hidden = true)
  @ManyToMany(fetch = FetchType.LAZY, mappedBy = "users")
  @SaturnColumn(description="角色和人员的关联信息")
  private Set<RoleEntity> roles;
  
  @ApiModelProperty(name="userHead" , value="人员头像" , required=false)
  @Column(name = "user_head", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '人员头像'")
  @SaturnColumn(description="人员头像")
  private String userHead = "";
  
  @ApiModelProperty(name="gender" , value="性别.0保密，1男 2女" , required=false)
  @Column(name = "gender" , nullable=true, columnDefinition = "int(11) COMMENT '性别.0保密，1男 2女'")
  @SaturnColumn(description="人员性别")
  private Integer gender = 0;
  
  @ManyToMany(fetch=FetchType.LAZY , mappedBy="users")
  @SaturnColumn(description="所属组织机构")
  private Set<OrganizationEntity> orgs;
  
  @ManyToMany(fetch=FetchType.LAZY , mappedBy="users")
  @SaturnColumn(description="所属用户组")
  private Set<UserGroupEntity> groups;

  @OrderBy("createTime")
  @ManyToMany(fetch=FetchType.LAZY , mappedBy="users")
  @SaturnColumn(description="所属岗位（目前逻辑限制只有一个）")
  private Set<PositionEntity> positions;
  
  public String getUserName() {
    return userName;
  }
  public void setUserName(String userName) {
    this.userName = userName;
  }
  public String getAccount() {
    return account;
  }
  public void setAccount(String account) {
    this.account = account;
  }
  public String getPhone() {
    return phone;
  }
  public void setPhone(String phone) {
    this.phone = phone;
  }
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getEntryTime() {
    return entryTime;
  }
  public void setEntryTime(Date entryTime) {
    this.entryTime = entryTime;
  }
  public Date getLastloginTime() {
    return lastloginTime;
  }
  public void setLastloginTime(Date lastloginTime) {
    this.lastloginTime = lastloginTime;
  }
  public Integer getUseStatus() {
    return useStatus;
  }
  public void setUseStatus(Integer useStatus) {
    this.useStatus = useStatus;
  }
  public Set<RoleEntity> getRoles() {
    return roles;
  }
  public void setRoles(Set<RoleEntity> roles) {
    this.roles = roles;
  }
  public String getUserHead() {
    return userHead;
  }
  public void setUserHead(String userHead) {
    this.userHead = userHead;
  }
  public Integer getGender() {
    return gender;
  }
  public void setGender(Integer gender) {
    this.gender = gender;
  }
  public Set<OrganizationEntity> getOrgs() {
    return orgs;
  }
  public void setOrgs(Set<OrganizationEntity> orgs) {
    this.orgs = orgs;
  }
  public Set<UserGroupEntity> getGroups() {
    return groups;
  }
  public void setGroups(Set<UserGroupEntity> groups) {
    this.groups = groups;
  }
  public Set<PositionEntity> getPositions() {
    return positions;
  }
  public void setPositions(Set<PositionEntity> positions) {
    this.positions = positions;
  }
}