package com.bizunited.platform.core.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModelProperty;

/**
 * 在实际建模过程中，我们发现很多模型都需要类似创建人、创建时间、修改人、修改时间这样的设定<br>
 * 为了同时满足多个模型上这样的需求，我们将这部分属性专门提取出来形成UuidOpEntity上层抽象类
 * @author yinwenjie
 */
@MappedSuperclass
public abstract class UuidOpEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 7279565457132917600L;
  /** 创建人 */
  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "create_user", columnDefinition = "varchar(255) COMMENT '创建人'")
  @SaturnColumn(description = "创建人")
  private UserEntity createUser;
  /** 最后更新人 */
  @ApiModelProperty(name = "modifyUser", value = "最后更新人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "modify_user", columnDefinition = "varchar(255) COMMENT '最后更新人'")
  @SaturnColumn(description = "最后更新人")
  private UserEntity modifyUser;
  /** 创建时间 */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /** 最后更新时间 */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
  @Column(name = "modify_time" , columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;
  public UserEntity getCreateUser() {
    return createUser;
  }
  public void setCreateUser(UserEntity createUser) {
    this.createUser = createUser;
  }
  public UserEntity getModifyUser() {
    return modifyUser;
  }
  public void setModifyUser(UserEntity modifyUser) {
    this.modifyUser = modifyUser;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}