package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.SystemThemeEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;


@Repository
public interface SystemThemeRepository extends
    JpaRepository<SystemThemeEntity, String>,
    JpaSpecificationExecutor<SystemThemeEntity> {

  /**
   * 根据相对路径与文件名，查询主题实体信息
   * @param relativeLocal
   * @param fileName
   * @return
   */
  @Query("from SystemThemeEntity th where th.relativeLocal = :relativeLocal and th.fileName = :fileName")
  public SystemThemeEntity findByRelativeLocalAndFileName(@Param("relativeLocal") String relativeLocal , @Param("fileName") String fileName);

}
