package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 数据视图权限拦截器持久化接口定义
 * @Author: Paul Chan
 * @Date: 2019-12-23 10:21
 */
@Repository("DataViewAuthInterceptorRepository")
public interface DataViewAuthInterceptorRepository extends JpaRepository<DataViewAuthInterceptorEntity, String>,
    JpaSpecificationExecutor<DataViewAuthInterceptorEntity> {

  /**
   * 根据数据视图ID查询
   * @param dataViewId
   * @return
   */
  @Query("select dvai from DataViewAuthInterceptorEntity dvai where dvai.dataView.id = :dataViewId")
  DataViewAuthInterceptorEntity findByDataView(@Param("dataViewId") String dataViewId);

  /**
   * 根据数据视图编码查询
   * @param dataViewCode
   * @return
   */
  @Query("select dvai from DataViewAuthInterceptorEntity dvai where dvai.dataView.code = :dataViewCode")
  DataViewAuthInterceptorEntity findByDataViewCode(@Param("dataViewCode") String dataViewCode);
}
