package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.Set;

/**
 * DataViewAuthVerticalEntity业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_DataViewAuthVerticalRepository")
public interface DataViewAuthVerticalRepository
    extends
    JpaRepository<DataViewAuthVerticalEntity, String>
    , JpaSpecificationExecutor<DataViewAuthVerticalEntity> {

  /**
   * 按照对应的视图进行详情查询（包括关联信息），这里查询的是
   *
   * @param dataViewCode 对应的视图
   */
  @Query("select distinct dataViewAuthVerticalEntity from DataViewAuthVerticalEntity dataViewAuthVerticalEntity "
      + " left join fetch dataViewAuthVerticalEntity.authRelations dataViewAuthVerticalEntity_authRelations "
      + " left join fetch dataViewAuthVerticalEntity.displayFields dataViewAuthVerticalEntity_displayFields "
      + " left join fetch dataViewAuthVerticalEntity.dataView dataViewAuthVerticalEntity_dataView "
      + " left join fetch dataViewAuthVerticalEntity.field dataViewAuthVerticalEntity_field "
      + " where dataViewAuthVerticalEntity_dataView.code = :dataViewCode order by dataViewAuthVerticalEntity.sortIndex")
  public Set<DataViewAuthVerticalEntity> findDetailsByDataViewCode(@Param("dataViewCode") String dataViewCode);

  /**
   * 按照关联的多个 对应的视图进行详情查询
   *
   * @param dataViewIds
   * @return
   */
  @Query("select distinct dataViewAuthVerticalEntity from DataViewAuthVerticalEntity dataViewAuthVerticalEntity "
      + " left join fetch dataViewAuthVerticalEntity.authRelations dataViewAuthVerticalEntity_authRelations "
      + " left join fetch dataViewAuthVerticalEntity.displayFields dataViewAuthVerticalEntity_displayFields "
      + " left join fetch dataViewAuthVerticalEntity.dataView dataViewAuthVerticalEntity_dataView "
      + " left join fetch dataViewAuthVerticalEntity.field dataViewAuthVerticalEntity_field "
      + " where dataViewAuthVerticalEntity_dataView.id in (:dataViewIds)")
  public Set<DataViewAuthVerticalEntity> findDetailsByDataViewIds(@Param("dataViewIds") String[] dataViewIds);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   *
   * @param id 主键
   */
  @Query("select distinct dataViewAuthVerticalEntity from DataViewAuthVerticalEntity dataViewAuthVerticalEntity "
      + " left join fetch dataViewAuthVerticalEntity.authRelations dataViewAuthVerticalEntity_authRelations "
      + " left join fetch dataViewAuthVerticalEntity.displayFields dataViewAuthVerticalEntity_displayFields "
      + " left join fetch dataViewAuthVerticalEntity.dataView dataViewAuthVerticalEntity_dataView "
      + " left join fetch dataViewAuthVerticalEntity.field dataViewAuthVerticalEntity_field "
      + " where dataViewAuthVerticalEntity.id=:id ")
  public DataViewAuthVerticalEntity findDetailsById(@Param("id") String id);


  /**
   * 根据视图ID，删除所有的纵向权限信息
   *
   * @param dataViewId
   */
  @Modifying
  @Transactional
  @Query("delete from DataViewAuthVerticalEntity m where m.dataView.id = :dataViewId")
  public void deleteByDataView(@Param("dataViewId") String dataViewId);

  /**
   * 删除需要显示的字段集
   *
   * @param id
   * @param authVerticalId
   */
  @Modifying
  @Query(value = "delete from engine_dataview_auth_field_mapping where field_id = :id and auth_vertical_id = :authVerticalId", nativeQuery = true)
  void deleteByDisplayFieldIdAndAuthVerticalId(@Param("id") String id, @Param("authVerticalId") String authVerticalId);

  /**
   * 新增需要显示的字段集
   *
   * @param displayFieldsId
   * @param authVerticalId
   */
  @Modifying
  @Query(value = "insert into engine_dataview_auth_field_mapping (auth_vertical_id , field_id) values (:authVerticalId , :displayFieldsId)", nativeQuery = true)
  void saveByDisplayFieldIdAndAuthVerticalId(@Param("displayFieldsId") String displayFieldsId, @Param("authVerticalId") String authVerticalId);

  /**
   * 根据字段ID查询纵向权限信息
   * @param fieldId
   */
  @Query("select dvav from DataViewAuthVerticalEntity dvav inner join dvav.field dvf where dvf.id = :fieldId")
  Set<DataViewAuthVerticalEntity> findByField(@Param("fieldId") String fieldId);
}