package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewFilterEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.List;

/**
 * DataViewFilterEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DataViewFilterRepository")
public interface DataViewFilterRepository
    extends
      JpaRepository<DataViewFilterEntity, String>
      ,JpaSpecificationExecutor<DataViewFilterEntity>
  {
  /**
   * 按照对应的视图进行查询
   * @param dataViewId 对应的视图
   */
  @Query("from DataViewFilterEntity dataViewFilterEntity " 
      + " left join fetch dataViewFilterEntity.dataView dataView " 
      + " where dataView.id = :dataViewId")
  public List<DataViewFilterEntity> findByDataView(@Param("dataViewId") String dataViewId);
  /**
   * 按照结构字段进行查询
   * @param fieldId 结构字段
   */
  @Query("from DataViewFilterEntity dataViewFilterEntity " 
      + " left join fetch dataViewFilterEntity.field field " 
      + " where field.id = :fieldId")
  public List<DataViewFilterEntity> findByField(@Param("fieldId") String fieldId);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dataViewFilterEntity from DataViewFilterEntity dataViewFilterEntity "
      + " left join  fetch dataViewFilterEntity.dataView dataViewFilterEntity_dataView "
      + " left join  fetch dataViewFilterEntity.field dataViewFilterEntity_field "
      + " where dataViewFilterEntity.id=:id ")
  public DataViewFilterEntity findDetailsById(@Param("id") String id);


  @Modifying
  @Transactional
  @Query("delete from DataViewFilterEntity filter where filter.id = :id")
  public void deleteById(@Param("id") String id);
}