package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewGroupEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * DataViewGroupEntity业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_DataViewGroupRepository")
public interface DataViewGroupRepository
    extends JpaRepository<DataViewGroupEntity, String>,
        JpaSpecificationExecutor<DataViewGroupEntity> {
  /**
   * 按照数据源ID进行查询
   *
   * @param dataSourceId 数据源ID
   */
  @Query(
      "from DataViewGroupEntity dataViewGroupEntity "
          + " left join fetch dataViewGroupEntity.dataSource dataSource "
          + " where dataSource.id = :dataSourceId")
  public List<DataViewGroupEntity> findByDataSource(@Param("dataSourceId") String dataSourceId);
  /** 获取主数据源下的分组信息 */
  @Query(
      "from DataViewGroupEntity dataViewGroupEntity "
          + " where dataViewGroupEntity.dataSource is null")
  public List<DataViewGroupEntity> findByDataSource();

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   *
   * @param id 主键
   */
  @Query(
      "select distinct dataViewGroupEntity from DataViewGroupEntity dataViewGroupEntity "
          + " left join  fetch dataViewGroupEntity.dataSource dataViewGroupEntity_dataSource "
          + " where dataViewGroupEntity.id=:id ")
  public DataViewGroupEntity findDetailsById(@Param("id") String id);

  /**
   * 按照数据源code查询DataViewGroupEntity
   *
   * @param code
   * @return
   */
  @Query(
      "select distinct dataViewGroupEntity from DataViewGroupEntity dataViewGroupEntity "
          + " left join  fetch dataViewGroupEntity.dataSource dataViewGroupEntity_dataSource "
          + " where dataViewGroupEntity_dataSource.code=:code ")
  public List<DataViewGroupEntity> findByDataSourceCode(@Param("code") String code);

  /** 详情查询（包括关联信息） */
  @Query(
      "select distinct dataViewGroupEntity from DataViewGroupEntity dataViewGroupEntity "
          + " left join  fetch dataViewGroupEntity.dataSource dataViewGroupEntity_dataSource ")
  List<DataViewGroupEntity> findDetails();

  /**
   * 根据编码查询
   *
   * @param code
   * @return
   */
  DataViewGroupEntity findByCode(String code);
}
