package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * SQL分析接口定义，在执行sql前，对sql进行分页、参数、权限等处理
 * @Author: Paul Chan
 * @Date: 2019-10-09 15:54
 */
public interface SqlAnalysis {

  /**
   * 对sql执行分析
   */
  void analysis();

  /**
   * 进行sql参数设置值
   * @param object
   */
  void processSQLParams(Object object);

  /**
   * 设置预置信息
   * @param systems
   * @param authHorzontals
   * @param verticalPresets
   */
  void setPresets(Map<String,Object> systems, Map<String,Object> authHorzontals, Map<Integer,Object> verticalPresets);

  Map<SQLCorrelationEnum, Object> getResult();

  Pageable getPageable();
}
