package com.bizunited.platform.core.repository.dynamic;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * TODO 还没写注释
 * @author yinwenjie
 */
public class DynamicDataSourceThreadFactory implements ThreadFactory {

  private DynamicDataSourceManager dynamicDataSourceManger;
  
  private AtomicInteger threadIndex = new AtomicInteger(0);
  
  public DynamicDataSourceThreadFactory(DynamicDataSourceManager dynamicDataSourceManger) {
    this.dynamicDataSourceManger = dynamicDataSourceManger;
  }
  
  /* (non-Javadoc)
   * @see java.util.concurrent.ThreadFactory#newThread(java.lang.Runnable)
   */
  @Override
  public Thread newThread(Runnable r) {
    DynamicDataSourceThread currentThread = new DynamicDataSourceThread(r, this.dynamicDataSourceManger);
    currentThread.setName("dynamic-datasource-task-" + this.threadIndex.getAndIncrement());
    return currentThread;
  }
}
