package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.CodeRuleEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;
import java.util.Map;

/**
 * CodeRuleRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 12/Jun/2019 15:01
 */
@Repository("CodeRuleRepositoryImpl")
public class CodeRuleRepositoryImpl implements CodeRuleRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String RULE_NAME = "ruleName";
  private static final String RULE_CODE = "ruleCode";
  private static final String RULE_TYPE = "ruleType";
  private static final String LANGUAGE = "language";
  
  @SuppressWarnings("unchecked")
  @Override
  public Page<CodeRuleEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 目前的查询条件是：表单名、业务领域、项目名
     * */
    String hql = "from CodeRuleEntity cgr where 1=1 ";
    String countHql = "select count(*) from CodeRuleEntity cgr where 1=1 ";

    // 编码生成规则的名称
    Object ruleName = conditions.get(RULE_NAME);
    if(ruleName != null) {
      hql += " AND cgr.ruleName = :ruleName ";
      countHql += " AND cgr.ruleName = :ruleName ";
    }

    // 编码生成规则的编号
    Object ruleCode = conditions.get(RULE_CODE);
    if(ruleCode != null) {
      hql += " AND cgr.ruleCode = :ruleCode ";
      countHql += " AND cgr.ruleCode = :ruleCode ";
    }

    // 编码生成规则的类别
    Object ruleType = conditions.get(RULE_TYPE);
    if(ruleType != null) {
      hql += " AND cgr.ruleType = :ruleType ";
      countHql += " AND cgr.ruleType = :ruleType ";
    }

    // 编码生成规则的说明
    Object language = conditions.get(LANGUAGE);
    if(language != null) {
      hql += " AND cgr.language = :language ";
      countHql += " AND cgr.language = :language ";
    }


    hql += " order by cgr.createTime desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);

    if(ruleName != null) {
      query.setParameter(RULE_NAME, ruleName);
      countQuery.setParameter(RULE_NAME, ruleName);
    }

    if(ruleCode != null) {
      query.setParameter(RULE_CODE, ruleCode);
      countQuery.setParameter(RULE_CODE, ruleCode);
    }

    if(ruleType != null) {
      query.setParameter(RULE_TYPE, ruleType);
      countQuery.setParameter(RULE_TYPE, ruleType);
    }

    if(language != null) {
      query.setParameter(LANGUAGE, language);
      countQuery.setParameter(LANGUAGE, language);
    }


    // 构造返回信息和最新的分页结果
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<CodeRuleEntity> resutls = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count);
  }
}
