package com.bizunited.platform.core.repository.internal;

import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;

/**
 * @author yinwenjie
 */
@Repository("DynamicTaskSchedulerRepositoryImpl")
public class DynamicTaskSchedulerRepositoryImpl implements DynamicTaskSchedulerRepositoryCustom {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String TASK_TYPE = "taskType";
  private static final String TASK_CODE = "taskCode";
  private static final String WORKING_STATUS = "workingStatus";
  private static final String T_STATUS = "tstatus";
  private static final String TASK_DESC = "taskDesc";
  private static final String INVOKE_TYPE = "invokeType";
  
  @SuppressWarnings("unchecked")
  @Override
  public Page<DynamicTaskSchedulerEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * -按照任务类型、任务编码、运行状态、任务状态、任务名称进行查询
     * */
    String hql = "from DynamicTaskSchedulerEntity dt left join fetch dt.createUser c left join fetch dt.modifyUser m where 1 = 1";
    String countHql = "select count(*) from DynamicTaskSchedulerEntity dt where 1 = 1";
    // 任务类型
    Object taskType = conditions.get(TASK_TYPE);
    if(taskType != null) {
        hql += " AND dt.taskType = :taskType ";
        countHql += " AND dt.taskType = :taskType ";
    }
    // 任务编码
    Object taskCode = conditions.get(TASK_CODE);
    if(taskCode != null) {
        hql += " AND dt.taskCode = :taskCode ";
        countHql += " AND dt.taskCode = :taskCode ";
    }
    // 运行状态
    Object workingStatus = conditions.get(WORKING_STATUS);
    if (workingStatus != null) {
        hql += " AND dt.workingStatus = :workingStatus ";
        countHql += " AND dt.workingStatus = :workingStatus ";
    }
    // 任务状态
    Object tstatus = conditions.get(T_STATUS);
    if(tstatus != null) {
        hql += " AND dt.tstatus = :tstatus ";
        countHql += " AND dt.tstatus = :tstatus ";
    }
    // 任务名称
    Object taskDesc = conditions.get(TASK_DESC);
    if(taskDesc != null) {
        hql += " AND dt.taskDesc = :taskDesc ";
        countHql += " AND dt.taskDesc = :taskDesc ";
    }
    // 脚本执行类型
    Object invokeType = conditions.get(INVOKE_TYPE);
    if(invokeType != null) {
        hql += " AND dt.invokeType = :invokeType ";
        countHql += " AND dt.invokeType = :invokeType ";
    }
    hql += " order by dt.createTime desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    // 任务类型
    if(taskType != null) {
      query.setParameter(TASK_TYPE, taskType);
      countQuery.setParameter(TASK_TYPE, taskType);
    }
    // 任务编码
    if(taskCode != null) {
      query.setParameter(TASK_CODE, taskCode);
      countQuery.setParameter(TASK_CODE, taskCode);
    }
    // 运行状态
    if (workingStatus != null) {
      query.setParameter(WORKING_STATUS, workingStatus);
      countQuery.setParameter(WORKING_STATUS, workingStatus);
    }
    // 任务状态
    if(tstatus != null) {
      query.setParameter(T_STATUS, tstatus);
      countQuery.setParameter(T_STATUS, tstatus);
    }
    // 任务名称
    if(taskDesc != null) {
      query.setParameter(TASK_DESC, taskDesc);
      countQuery.setParameter(TASK_DESC, taskDesc);
    }
    // 脚本执行类型
    if(invokeType != null) {
      query.setParameter(INVOKE_TYPE, invokeType);
      countQuery.setParameter(INVOKE_TYPE, invokeType);
    }

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<DynamicTaskSchedulerEntity> results = query.getResultList();

    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    PageImpl<DynamicTaskSchedulerEntity> currentPage = new PageImpl<>(results,pageable,count);
    return currentPage;
  }
}