package com.bizunited.platform.core.repository.internal;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 分页查询实现基础类
 * @Author: Paul Chan
 * @Date: 2019-08-27 15:38
 */
public interface PageRepositoryImpl {

  /**
   * 查询分页数据
   * 该方法将分页查询的过程进行抽象化，在持久层可实现此类，用此方法完成分页查询，
   * 目前并没有pageable的排序信息进行处理，请在调用该方法前自行处理hql的排序信息
   * @param entityManager 实体管理器
   * @param hql 查询sql
   * @param countHql 查询sql
   * @param parameter sql对应的参数，k-v数据结构，Object为jpa可识别的对象，如基本数据类型和Date等
   * @param pageable 分页信息
   * @param <T>
   * @return
   */
  @SuppressWarnings("unchecked")
  default <T> Page<T> queryByConditions(EntityManager entityManager, String hql, String countHql, Map<String, Object> parameter, Pageable pageable){
    Query query = entityManager.createQuery(hql);
    Query countQuery = entityManager.createQuery(countHql);
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<T> result;
    long count = (long)countQuery.getResultList().get(0);
    if(count > 0) {
      result = query.getResultList();
    } else {
      result = new ArrayList<>();
    }
    return new PageImpl<>(result, pageable, count);
  }

}
