package com.bizunited.platform.core.repository.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import com.bizunited.platform.core.entity.RemoteServiceEntity;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import java.util.HashMap;
import java.util.Map;

/**
 * RemoteServiceRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 16:38
 */
@Service("RemoteServiceRepositoryImpl")
public class RemoteServiceRepositoryImpl implements RemoteServiceRepositoryCustom, PageRepositoryImpl {
  
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String REMOTE_SERVICE_TYPE = "remoteServiceType";
  private static final String ADDRESS_CODE = "addressCode";
  private static final String ADDRESS_ALIAS = "addressAlias";
  private static final String REQUEST_METHOD = "requestMethod";
  private static final String REMOTE_SERVICE_STATUS = "remoteServiceStatus";

  @Override
  public Page<RemoteServiceEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("select u from RemoteServiceEntity u inner join fetch u.remoteServiceAddress r where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from RemoteServiceEntity u inner join u.remoteServiceAddress r where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(8);
    Object remoteServiceType = conditions.get(REMOTE_SERVICE_TYPE);
    if(remoteServiceType != null) {
      condition.append(" AND u.remoteServiceType = :remoteServiceType ");
      parameter.put("remoteServiceType", remoteServiceType);
    }

    Object addressCode = conditions.get(ADDRESS_CODE);
    if(addressCode != null) {
      condition.append(" AND r.code = :addressCode ");
      parameter.put("addressCode", addressCode);
    }

    Object addressAlias = conditions.get(ADDRESS_ALIAS);
    if(addressAlias != null) {
      condition.append(" AND r.alias = :addressAlias ");
      parameter.put("addressAlias", addressAlias);
    }

    Object requestMethod = conditions.get(REQUEST_METHOD);
    if(requestMethod != null) {
      condition.append(" AND u.requestMethod = :requestMethod ");
      parameter.put("requestMethod", requestMethod);
    }

    Object remoteServiceStatus = conditions.get(REMOTE_SERVICE_STATUS);
    if(remoteServiceStatus != null) {
      condition.append(" AND u.remoteServiceStatus = :remoteServiceStatus ");
      parameter.put("remoteServiceStatus", remoteServiceStatus);
    }
    hql.append(condition);
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable);
  }
}
