package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.common.constant.ParamClassTypeConst;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author yinwenjie
 */
@Repository("ServicableMethodRepositoryImpl")
public class ServicableMethodRepositoryImpl implements ServicableMethodRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String USED_SCOPE = "usedScope";
  private static final String INTERFACE_NAME = "interfaceName";
  private static final String SIMPLE_METHOD_NAME = "simpleMethodName";
  private static final String RETURN_CLASS_NAME = "returnClassName";
  private static final String PROPERTY_CLASS_NAME = "propertyClassName";
  private static final String DESCRIPTION = "description";
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.ServicableMethodRepositoryCustom#queryPage(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @SuppressWarnings({"unchecked", "rawtypes"})
  @Override
  public Page<ServicableMethodEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    Map<String, Object> currentConditions = conditions;
    if(currentConditions == null) {
      currentConditions = new HashMap<>();
    }
    /*
     * 可以支持的查询包括：
     * 服务源名称、服务接口类全称、后端方法名简称
     * */
    String hql = "select distinct sm from ServicableMethodEntity sm left join fetch sm.properties smp where 1=1 ";
    String countSql = "select count(*) from engine_service_method sm left join engine_service_method_property smp on sm.id = smp.service_method_id where 1=1 ";
    
    // 服务源方法的应用范围：读操作（READ） 写操作（WRITE）
    if(currentConditions.get(USED_SCOPE) != null) {
      hql += " and sm.usedScope = :usedScope ";
      countSql += " and sm.used_scope = :usedScope ";
    }
    // 可能的服务源名称查询条件
    if(currentConditions.get("name") != null) {
      hql += " and sm.name like CONCAT('%', CONCAT(:name, '%')) ";
      countSql += " and sm.name like CONCAT('%', CONCAT(:name, '%')) ";
    }
    // 可能的服务接口类全称
    if(currentConditions.get(INTERFACE_NAME) != null) {
      hql += " and sm.interfaceName = :interfaceName ";
      countSql += " and sm.interface_name = :interfaceName ";
    }
    // 可能的后端方法简称
    if(currentConditions.get(SIMPLE_METHOD_NAME) != null) {
      hql += " and sm.simpleMethodName = :simpleMethodName ";
      countSql += " and sm.simple_method_name = :simpleMethodName ";
    }
    // 可能的返回值类型条件
    if(currentConditions.get(RETURN_CLASS_NAME) != null) {
      hql += " and sm.returnClassName = :returnClassName ";
      countSql += " and sm.return_classname = :returnClassName ";
    }
    // 可能的参数类型条件
    if(currentConditions.get(PROPERTY_CLASS_NAME) != null) {
      hql += " and smp.paramClass = :propertyClassName ";
      countSql += " and smp.param_class = :propertyClassName ";
    }
    // 可能的方法中文描述（支持模糊查询）
    Object description = currentConditions != null?currentConditions.get(DESCRIPTION):null;
    if(description != null) {
      hql += " AND sm.description like CONCAT('%',:description,'%') ";
      countSql += " AND sm.description like CONCAT('%',:description,'%') ";
    }
    // 按照服务源名称进行排序，这样好找
    hql += " order by sm.name desc ";
    
    // 开始传入条件
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createNativeQuery(countSql);
    
    // 服务源方法的应用范围：查询，创建，更新
    if(currentConditions.get(USED_SCOPE) != null) {
      query.setParameter(USED_SCOPE, currentConditions.get(USED_SCOPE));
      countQuery.setParameter(USED_SCOPE, currentConditions.get(USED_SCOPE));
    }
    // 可能的服务源名称查询条件
    if(currentConditions.get("name") != null) {
      query.setParameter("name", currentConditions.get("name"));
      countQuery.setParameter("name", currentConditions.get("name"));
    }
    // 可能的服务接口类全称
    if(currentConditions.get(INTERFACE_NAME) != null) {
      query.setParameter(INTERFACE_NAME, currentConditions.get(INTERFACE_NAME));
      countQuery.setParameter(INTERFACE_NAME, currentConditions.get(INTERFACE_NAME));
    }
    // 可能的后端方法简称
    if(currentConditions.get(SIMPLE_METHOD_NAME) != null) {
      query.setParameter(SIMPLE_METHOD_NAME, currentConditions.get(SIMPLE_METHOD_NAME));
      countQuery.setParameter(SIMPLE_METHOD_NAME, currentConditions.get(SIMPLE_METHOD_NAME));
    }
    // 可能的返回值类型条件
    if(currentConditions.get(RETURN_CLASS_NAME) != null) {
      query.setParameter(RETURN_CLASS_NAME, currentConditions.get(RETURN_CLASS_NAME));
      countQuery.setParameter(RETURN_CLASS_NAME, currentConditions.get(RETURN_CLASS_NAME));
    }
    // 可能的参数类型条件
    if(currentConditions.get(PROPERTY_CLASS_NAME) != null) {
      query.setParameter(PROPERTY_CLASS_NAME, currentConditions.get(PROPERTY_CLASS_NAME));
      countQuery.setParameter(PROPERTY_CLASS_NAME, currentConditions.get(PROPERTY_CLASS_NAME));
    }
    // 可能的方法中文描述（支持模糊查询）
    if(description != null) {
      query.setParameter(DESCRIPTION, currentConditions.get(DESCRIPTION));
      countQuery.setParameter(DESCRIPTION, currentConditions.get(DESCRIPTION));
    }
    
    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<ServicableMethodEntity> resutls = transParamClassType(query.getResultList());
    
    // 查询总数量信息
    BigInteger count = (BigInteger)countQuery.getResultList().get(0);
    return new PageImpl(resutls,pageable,count.intValue());
  }
  
  /**
   * 把jvm对应的java基础类型，转成与前端约定的枚举值
   * @param resutls
   * @return
   */
  private List<ServicableMethodEntity> transParamClassType(List<ServicableMethodEntity> resutls) {
    for(ServicableMethodEntity method : resutls) {
      if(method.getProperties() != null && method.getProperties().size() > 0) {
        for(ServicableMethodPropertyEntity param : method.getProperties()) {
          if(ParamClassTypeConst.baseClassMapContainsKey(param.getParamClass())) {
            param.setParamClass(ParamClassTypeConst.getBaseClass(param.getParamClass()).toString());
          }
        }
      }
    }
    return resutls;
  }
}
