package com.bizunited.platform.core.repository.internal;

import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.UserEntity;

/**
 * 自定义的比较复杂的用户信息的数据层操作定义
 * @author yinwenjie
 */
@Repository("UserRepositoryCustom")
public interface UserRepositoryCustom {
  /**
   * 这是分页方法的雏形，可以根据业务要求进行修改
   */
  Page<UserEntity> findByConditions(Pageable pageable , Map<String, Object> conditions);
}