package com.bizunited.platform.core.repository.migrate;

import com.bizunited.platform.core.entity.MigrateConfigAnalysisEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * MigrateConfigAnalysisRepository
 *
 * @description:
 * @author: yanwe
 * @date: 03/Sep/2019 16:28
 */
@Repository("MigrateConfigAnalysisRepository")
public interface MigrateConfigAnalysisRepository extends JpaRepository<MigrateConfigAnalysisEntity,String>, JpaSpecificationExecutor<MigrateConfigAnalysisEntity> {


  @Query("select m from MigrateConfigAnalysisEntity m left join m.migrateImportEntity mi where mi.id = :importId")
  Set<MigrateConfigAnalysisEntity> findByImportId(@Param("importId")String importId);


}
