package com.bizunited.platform.core.repository.migrate;

import com.bizunited.platform.core.entity.MigrateImportEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;
import java.util.Map;

/**
 * MigrateImportRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 03/Sep/2019 15:38
 */
@Repository("MigrateImportRepositoryImpl")
public class MigrateImportRepositoryImpl implements MigrateImportRepositoryCustom {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String MESS_FILE_TYPE = "fileType";
  private static final String MESS_CODE = "code";
  private static final String MESS_EXECUTED = "executed";

  @SuppressWarnings("unchecked")
  @Override
  public Page<MigrateImportEntity> findByConditions(
      Pageable pageable, Map<String, Object> conditions) {
    /*
     * 按照需求，是按照名称、编码、状态进行查询
     */
    String hql =
        "from MigrateImportEntity u where 1 = 1";
    String countHql = "select count(*) from MigrateImportEntity u where 1 = 1 "; 
    
    Object fileType = conditions.get(MESS_FILE_TYPE);
    if (fileType != null) {
      hql += " AND u.fileType = :fileType ";
      countHql += " AND u.fileType = :fileType ";
    }
    Object code = conditions.get(MESS_CODE);
    if (code != null) {
      hql += " AND u.code = :code ";
      countHql += " AND u.code = :code ";
    }
    Object executed = conditions.get(MESS_EXECUTED);
    if (executed != null) {
      hql += " AND u.executed = :executed ";
      countHql += " AND u.executed = :executed ";
    }
    hql += " order by u.createTime desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    
    if (fileType != null) {
      query.setParameter(MESS_FILE_TYPE, fileType);
      countQuery.setParameter(MESS_FILE_TYPE, fileType);
    }
    if (code != null) {
      query.setParameter(MESS_CODE, code);
      countQuery.setParameter(MESS_CODE, code);
    }
    if (executed != null) {
      query.setParameter(MESS_EXECUTED, executed);
      countQuery.setParameter(MESS_EXECUTED, executed);
    }

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<MigrateImportEntity> results = query.getResultList();

    // 查询总数量信息
    long count = (long) countQuery.getResultList().get(0);
    return new PageImpl<>(results, pageable, count);
  }
}
