package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.DictItemEntity;

import java.util.List;
import java.util.Set;

/**
 * DictItemService
 *
 * @description:
 * @author: yanwe
 * @date: 11/Feb/2019 10:32
 */
public interface DictItemService {

  /**
   * 根据字典编码查询所有子项
   *
   * @param dictCode
   * @return
   */
  List<DictItemEntity> findItemsByCode(String dictCode);

  /**
   * 保存数据字典项（可能包含更新，但是现在业务目前没有更新）
   * @param dictCode
   * @param items
   * @return
   */
  Set<DictItemEntity> save(String dictCode, Set<DictItemEntity> items);

  /**
   * 启用单个明细
   * @param dictItemId
   * @return
   */
  DictItemEntity enable(String dictItemId);

  /**
   * 禁用单个明细
   * @param dictItemId
   * @return
   */
  DictItemEntity disable(String dictItemId);


  /**
   * 创建数据字典（添加单项）
   * @param dictCode
   * @param dictItem
   * @return
   */
  DictItemEntity create(String dictCode, DictItemEntity dictItem);
}
