package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;

import java.util.Set;

/**
 * 纵向权限选定的权限关系集DataViewAuthVerticalRelationEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewAuthVerticalRelationService {

  /**
   * 创建权限领域信息
   * @param dataViewAuthVerticalEntity
   * @param authRelations
   */
  public void create(DataViewAuthVerticalEntity dataViewAuthVerticalEntity, Set<DataViewAuthVerticalRelationEntity> authRelations);
  /**
   * 创建纵向权限选定的权限关系集时校验数据
   * @param dataViewAuthVerticalRelationEntity
   */
  public void createValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity);

  /**
   * 更新纵向权限选定的权限关系集时校验数据
   * @param dataViewAuthVerticalRelationEntity
   */
  public void updateValidation(DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity);


  /**
   * 按照关联的 纵向数据权限进行详情查询（包括关联信息）
   * @param authVertical 关联的 纵向数据权限
   */
  public Set<DataViewAuthVerticalRelationEntity> findDetailsByAuthVertical(String authVertical);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewAuthVerticalRelationEntity findDetailsById(String id);
  /**
   * 按照DataViewAuthVerticalRelationEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public DataViewAuthVerticalRelationEntity findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);

  /**
   * 删除
   * @param id
   */
  void deleteByAuthVertical(String authVerticalId);

  /**
   * 保存 处理可能的更新、增添、删除权限领域信息
   * @param authVertical
   * @param authRelations
   * @return
   */
  Set<DataViewAuthVerticalRelationEntity> save(DataViewAuthVerticalEntity authVertical, Set<DataViewAuthVerticalRelationEntity> authRelations);
}