package com.bizunited.platform.core.service.dataview;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;

import java.util.Set;

/**
 * DataViewAuthVerticalEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewAuthVerticalService {
  /**
   * 创建数据视图纵向权限
   */
  public Set<DataViewAuthVerticalEntity> create(Set<DataViewAuthVerticalEntity> authVerticals);

  /**
   * 创建时，验证实体
   * @param dataViewAuthVerticalEntity
   */
  public void createValidation(DataViewAuthVerticalEntity dataViewAuthVerticalEntity);

  /**
   * 更新数据视图纵向权限
   */
  public Set<DataViewAuthVerticalEntity> update(Set<DataViewAuthVerticalEntity> authVerticals , String dataViewId);

  /**
   * 更新时，验证实体
   * @param dataViewAuthVerticalEntity
   */
  public void updateValidation(DataViewAuthVerticalEntity dataViewAuthVerticalEntity);
  /**
   * 按照关联的 对应的视图进行详情查询，注意：这里的返回值已经脱离了JPA特性
   * @param dataView 关联的 对应的视图code
   */
  public Set<DataViewAuthVerticalEntity> findDetailsByDataViewCode(String dataView);
  /**
   * 按照关联的多个 对应的视图进行详情查询，注意：这里的返回值已经脱离了JPA特性
   * @param dataViewIds
   * @return
   */
  public Set<DataViewAuthVerticalEntity> findDetailsByDataViewIds(String[] dataViewIds);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewAuthVerticalEntity findDetailsById(String id);
  /**
   * 按照DataViewAuthVerticalEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public DataViewAuthVerticalEntity findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);

  /**
   * 强制删除纵向权限信息和纵向权限领域信息
   * @param dataViewEntity
   */
  void deleteByDataView(DataViewEntity dataViewEntity);

  /**
   * 根据字段ID删除纵向权限信息和纵向权限领域信息
   * @param fieldId
   */
  void deleteByField(String fieldId);
}