package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;

import java.util.List;
import java.util.Set;

/**
 * DataViewFilterEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewFilterService {
  /**
   * 在创建一个新的DataViewFilterEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  public void createValidation(DataViewFilterEntity dataViewFilterEntity);
  /**
   * 创建一个新的DataViewFilterEntity模型对象，ignoreValidate参数表示是否在进行创建前进行属性验证
   */
  public DataViewFilterEntity create(DataViewFilterEntity dataViewFilterEntity, boolean ignoreValidate);
  /**
   * 更新一个已有的DataViewFilterEntity模型对象，其主键属性必须有值
   */
  public DataViewFilterEntity update(DataViewFilterEntity dataViewFilterEntity);
  /**
   * 在更新一个已有的DataViewFilterEntity模型对象之前，检查对象各属性的正确性，其id属性必须有值
   */
  public void updateValidation(DataViewFilterEntity dataViewFilterEntity);
  /**
   * 按照对应的视图查询DataViewFilterEntity
   */
  public List<DataViewFilterEntity> findByDataView(String dataViewId);
  /**
   * 按照结构字段查询DataViewFilterEntity
   */
  public List<DataViewFilterEntity> findByField(String fieldId);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewFilterEntity findDetailsById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);
  /**
   * 按照field的id进行查询filter，如果有数据，就删除掉filter
   * @param fieldId
   */
  public void deleteByField(String fieldId);

  /**
   * 创建一个新的DataViewFilterEntity模型对象集合
   * @param filters
   * @param fields
   * @param dataViewEntity
   */
  void create(Set<DataViewFilterEntity> filters, Set<DataViewFieldEntity> fields, DataViewEntity dataViewEntity);

  /**
   * 更新数据视图筛选参数
   * @param dataView
   * @param filters
   * @return
   */
  Set<DataViewFilterEntity> update(DataViewEntity dataView, Set<DataViewFilterEntity> filters);
}