package com.bizunited.platform.core.service.dataview;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import java.util.List;

/**
 * DataViewGroupEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewGroupService {
  /**
   * 在创建一个新的DataViewGroupEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  public void createValidation(DataViewGroupEntity dataViewGroupEntity);
  /**
   * 创建一个新的DataViewGroupEntity模型对象，ignoreValidate参数表示是否在进行创建前进行属性验证
   */
  public DataViewGroupEntity create(DataViewGroupEntity dataViewGroupEntity, boolean ignoreValidate);
  /**
   * 更新一个已有的DataViewGroupEntity模型对象，其主键属性必须有值
   */
  public DataViewGroupEntity update(DataViewGroupEntity dataViewGroupEntity);
  /**
   * 在更新一个已有的DataViewGroupEntity模型对象之前，检查对象各属性的正确性，其id属性必须有值
   */
  public void updateValidation(DataViewGroupEntity dataViewGroupEntity);
  /**
   * 按照数据源ID查询DataViewGroupEntity
   */
  public List<DataViewGroupEntity> findByDataSource(String dataSourceId);
  /**
   * 按照数据源code查询DataViewGroupEntity
   */
  public List<DataViewGroupEntity> findByDataSourceCode(String code);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewGroupEntity findDetailsById(String id);
  /**
   *  按照主键进行信息的真删除
   * @param id 主键
   */
  public void deleteById(String id);

  /**
   * 将某一视图移动到新的分组
   * @param dataViewId
   * @param dataViewGroupId 所移致分组ID
   */
  void moveGroup(String dataViewId, String dataViewGroupId);
  /**
   * 按照数据源ID查询DataViewGroupEntity详情
   * 该接口用于返回前端特定的数据类型，展示视图分组信息
   * @param dataSourceId
   */
  public List<JSONObject> findDetailsByDataSource(String dataSourceId);

  /**
   * 根据编码查询
   * @param code
   * @return
   */
  DataViewGroupEntity findByCode(String code);
}