package com.bizunited.platform.core.service.dataview.internal;


import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.repository.dataview.DataSourceRepository;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * DataSourceEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("DataSourceEntityServiceImpl")
public class DataSourceServiceImpl implements DataSourceService {
  @Autowired
  private DataSourceRepository dataSourceRepository;
  
  @Override
  public DataSourceEntity findById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.dataSourceRepository.findById(id).orElse(null);
  }

  @Override
  public DataSourceEntity findDetailsByCode(String code) {
    if(StringUtils.isBlank(code)) { 
      return null;
    }
    return this.dataSourceRepository.findDetailsByCode(code);
  }

  @Override
  public List<DataSourceEntity> findByStatus(Integer status) {
    return this.dataSourceRepository.findByTstatus(status);
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.service.DataSourceService#findAll()
   */
  @Override
  public List<DataSourceEntity> findAll() {
    return this.dataSourceRepository.findAll();
  }

}
