package com.bizunited.platform.core.service.dataview.model;

import io.swagger.models.properties.StringProperty;

import java.io.Serializable;
import java.util.Date;

//TODO 注意：****该类是个临时过渡的类，后期会有变动****
public class SQLParamModel implements Serializable {
  private static final long serialVersionUID = 1L;

  /**
   * 参数名
   * 可以为空
   */
  private String paramName;

  /**
   * 可能的别名
   */
  private String aliasName;

  /**
   * 参数值
   * java基础类型，以及java原生的java.lang.String、java.util.Date等
   * 不支持集合或数组等
   */
  private transient Object value;

  /**
   * 参数本身java类类型
   */
  private String paramType;

  /**
   * 参数下标
   * 携带的下标值从0开始
   */
  private Integer index;

  /**
   * 参数传递方式
   * 1.外部传入
   * 2.固定值
   * 3.预制值
   */
  private Integer transferType;

  /**
   * 当参数传递方式为预制值时，该属性必须有值
   */
  private String paramKey;

  /**
   * 参数值可能需要转换的类型
   */
  private String mappingType;

  /**
   * 参数值转换时可能需要的格式
   */
  private String mappingPattern;

  /**可能的来源*/
  private Class<?> source;


  /**
   * 判断传入的数据是否是支持的java类型
   * @param obj
   * @return
   */
  public static final Boolean isSupportBaseClassType(Object obj){
    if(obj == null){
      return false;
    }

    Class<?> clz = null;
    if(obj instanceof String){
      try{
        clz = Class.forName(obj.toString());
      }catch (Exception e){
        return false;
      }
    }

    if(obj instanceof Class){
      clz = (Class<?>) obj;
    }

    if(clz == null){
      clz = obj.getClass();
    }

    // a、===
    if(clz.isPrimitive()
        || clz == Byte.TYPE || clz == Short.TYPE || clz == Integer.TYPE
        || clz == Long.TYPE || clz == Float.TYPE || clz == Double.TYPE
        || clz == Character.TYPE || clz == Boolean.TYPE
        || clz == Byte.class || clz == Short.class || clz == Integer.class
        || clz == Long.class || clz == Float.class || clz == Double.class
        || clz == Character.class || clz == Boolean.class ) {
      return true;
    }
    // b、===
    if(CharSequence.class.isAssignableFrom(clz)) {
      return true;
    }
    // c、===
    return (Date.class.isAssignableFrom(clz) || Number.class.isAssignableFrom(clz) || StringProperty.Format.class.isAssignableFrom(clz));
  }



  public String getAliasName() {
    return aliasName;
  }

  public void setAliasName(String aliasName) {
    this.aliasName = aliasName;
  }

  public String getParamName() {
    return paramName;
  }

  public void setParamName(String paramName) {
    this.paramName = paramName;
  }

  public Object getValue() {
    return value;
  }

  public void setValue(Object value) {
    this.value = value;
  }

  public String getParamType() {
    return paramType;
  }

  public void setParamType(String paramType) {
    this.paramType = paramType;
  }

  public Integer getIndex() {
    return index;
  }

  public void setIndex(Integer index) {
    this.index = index;
  }

  public Integer getTransferType() {
    return transferType;
  }

  public void setTransferType(Integer transferType) {
    this.transferType = transferType;
  }

  public String getMappingType() {
    return mappingType;
  }

  public void setMappingType(String mappingType) {
    this.mappingType = mappingType;
  }

  public String getMappingPattern() {
    return mappingPattern;
  }

  public void setMappingPattern(String mappingPattern) {
    this.mappingPattern = mappingPattern;
  }

  public String getParamKey() {
    return paramKey;
  }

  public void setParamKey(String paramKey) {
    this.paramKey = paramKey;
  }

  public Class<?> getSource() {
    return source;
  }

  public void setSource(Class<?> source) {
    this.source = source;
  }
}
