package com.bizunited.platform.core.service.file;

import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * nebula系统提供的默认模版，业务系统可自行实现替换默认模版
 * @Author: Paul Chan
 * @Date: 2020-02-10 17:08
 */
public class DefaultFileRelativeTemplate implements FileRelativeTemplate {


  /**
   * 使用日期作为文件夹的名字
   * @param subSystem
   * @param originalFilename
   * @return
   */
  @Override
  public String generatRelativePath(String subSystem, String originalFilename) {
    String relativePath;
    Date nowDate = new Date();
    String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
    if (!StringUtils.isBlank(subSystem)) {
      relativePath = StringUtils.join("/" , subSystem , "/" , folderName , "/" , (new Random().nextInt(100) % 10));
    } else {
      relativePath = StringUtils.join("/" , folderName , "/" , (new Random().nextInt(100) % 10));
    }
    return relativePath;
  }


}
