package com.bizunited.platform.core.service.invoke.handle.request;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import org.springframework.stereotype.Component;
import javax.transaction.Transactional;

@Component("TransactionalHandle")
public class TransactionalHandle implements InvokeRequestHandle  {

  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.ServicableRequestHandle#doHandle(com.bizunited.platform.core.service.invoke.ServicableContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  @Transactional(rollbackOn = Exception.class)
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    // 主要就是为了启动事务
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}