package com.bizunited.platform.core.service.invoke.model;

import org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

/**
 * 该筛选操作的类，目前并不完善，不能支持常用的SQL定义，如聚合操作，分析函数，差交并集等
 * 如暂不支持like，group by，sum，union等
 * 只支持简单的基本查询功能(注：不支持子查询)，并且基本查询也有部分限制约束，待继续完善
 * 可能后期会提供单独的SQL拼接实现的工具集包来支撑SQL的构造</p>
 * 
 * 形如：
 * select distinct current_table,relation_table </br>
 * from 当前表 current_table </br>
 * left join fetch  current_table.关联表属性 relation_table </br>
 * where  </br>
 * current_table.属性 支持的操作符 current_value </br>
 * and relation_table.属性 支持的操作符 relation_value </br>
 * or relation_table.属性 支持的操作符 relation_value2 </br>
 * order by current_table.属性 asc , relation_table.属性 desc
 */
public class InvokeOperations implements Serializable{
  private static final long serialVersionUID = 6443685264441659712L;
  
  public static final String DISTINCT = "distinct";
  
  private static final List<String> KEYWORD = Arrays.asList(DISTINCT);
  
  private static final List<String> RANGE_OPRT = Arrays.asList(
      InvokeParams.OprtCharType.BETWEEN.name(), InvokeParams.OprtCharType.IN.name(),
      InvokeParams.OprtCharType.NIN.name() , InvokeParams.OprtCharType.LC_RC.name(),
      InvokeParams.OprtCharType.LC_RO.name() , InvokeParams.OprtCharType.LO_RC.name() ,
      InvokeParams.OprtCharType.LO_RO.name()
  );
  
  /**
   * 字段名称
   */
  private String paramName;
  /**
   * 排序方式  升序ASC  降序DESC
   */
  private String sortType;
  /**
   * 排序先后  0最先，1其次，以此类推
   */
  private Integer sortIndex;
  /**
   * 筛选操作符类型：NEQ不等于   EQ等于   GT大于   LT小于   GE大于等于   LE小于等于   NULL(is null)   NOTNULL(is not null)
   * LC_RC全闭区间(大于等于 到 小于等于)   LO_RC左开右闭区间(大于 到 小于等于)    LO_RO全开区间(大于 到 小于)    LC_RO左闭右开区间(大于等于 到 小于) 
   * BETWEEN全闭区间比较   IN包含(注：不支持子查询)   NIN不包含(注：不支持子查询)   DISTINCT去重复(注：在一个不包含子查询和union操作的SELECT SQL中只能出现一次)
   * 目前暂不支持LIKE的操作和子查询
   * 注：
   * 当操作符是distinct时，paramValue为默认的distinct，并且relationClass不能有值
   */
  private String oprtType;
  /**
   * 筛选操作符需要比较的值
   */
  private transient Object compareValue;
  /**
   * 当前compareValue需要映射为什么数据类型
   * 比如原本数据是date类型，传递数据的时候是数字或字符串类型，我们需要映射为真正的date类型
   * 当运用于范围比较和包含关系时，必须传递该信息
   */
  private String mappingType;
  /**
   * 是否需要进行关联查询的SQL拼接
   * 当needRelation为true时，需要指定relationClass的类类型
   */
  private boolean needRelation = false;
  /**
   * 所属的关联类类型（目前只支持到第二层的关联）
   * 即只做到对当前类以及当前类的关联类这一层级
   */
  private String relationClass;
  /**
   * 子查询SQL  支持自定义的手写子查询语句
   */
  private String subSQL;
  
  
  /**
   * 判断是否属于范围区间的操作
   * @param oprtType
   * @return
   */
  public static boolean isRangeOprt(String oprtType) {
    return RANGE_OPRT.contains(oprtType);
  }
  
  
  /**
   * 判断paramName是否属于关键字
   * @param keyword
   * @return
   */
  public static boolean isKeyword(String keyword) {
    return KEYWORD.contains(keyword);
  }
  
  
  /**
   * 判断是否IN或NOT IN 操作
   * @param oprtType
   * @return
   */
  public static boolean isInOprt(String oprtType) {
    return StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.IN.name(), oprtType) ||
        StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.NIN.name(), oprtType);
  }
  
  /**
   * 判断是否BETWEEN操作
   * @param oprtType
   * @return
   */
  public static boolean isBetweenOprt(String oprtType) {
    return StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.BETWEEN.name(), oprtType);
  }
  
  /**
   * 判断是否LIKE操作
   * @param oprtType
   * @return
   */
  public static boolean isLikeOprt(String oprtType) {
    return StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.LIKE.name(), oprtType) ||
        StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.LLIKE.name(), oprtType) ||
        StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.RLIKE.name(), oprtType);
  }
  
  /**
   * 判断是否区间范围操作
   * @param oprtType
   * @return
   */
  public static boolean isRegionOprt(String oprtType) {
    return StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.LC_RC.name(), oprtType) ||
        StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.LO_RC.name(), oprtType) ||
        StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.LO_RO.name(), oprtType) ||
        StringUtils.equalsIgnoreCase(InvokeParams.OprtCharType.LC_RO.name(), oprtType);
  }
  
  
  /**
   * 判断compareValue是否是范围操作的数组
   * @param compareValue
   */
  public static boolean isRangeArray(String oprtType , Object compareValue) {
    return (isRangeOprt(oprtType) && compareValue instanceof Array);
  }
  
  /**
   * 判断操作符是否是IS NULL 或 IS NOT NULL
   * @param oprtType
   * @return
   */
  public static boolean nullOprt(String oprtType) {
    return StringUtils.equalsIgnoreCase(oprtType, InvokeParams.OprtCharType.NOTNULL.name())
        || StringUtils.equalsIgnoreCase(oprtType, InvokeParams.OprtCharType.NULL.name());
  }

  public static List<String> getKeyword(){
    return KEYWORD;
  }

  public static List<String> getRangeOprt(){
    return RANGE_OPRT;
  }
 

  public String getSubSQL() {
    return subSQL;
  }

  public void setSubSQL(String subSQL) {
    this.subSQL = subSQL;
  }

  public boolean isNeedRelation() {
    return needRelation;
  }
  public void setNeedRelation(boolean needRelation) {
    this.needRelation = needRelation;
  }
  public String getRelationClass() {
    return relationClass;
  }
  public void setRelationClass(String relationClass) {
    this.relationClass = relationClass;
  }
  public String getMappingType() {
    return mappingType;
  }
  public void setMappingType(String mappingType) {
    this.mappingType = mappingType;
  }
  public String getParamName() {
    return paramName;
  }
  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
  public String getSortType() {
    return sortType;
  }
  public void setSortType(String sortType) {
    this.sortType = sortType;
  }
  public String getOprtType() {
    return oprtType;
  }
  public void setOprtType(String oprtType) {
    this.oprtType = oprtType;
  }
  public Object getCompareValue() {
    return compareValue;
  }
  public void setCompareValue(Object compareValue) {
    this.compareValue = compareValue;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public int getSortIndexInt() {
    return sortIndex == null ? 0 : sortIndex.intValue();
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
}
