package com.bizunited.platform.core.service.security;

import com.bizunited.platform.core.common.enums.RbacRelationEnum;
import com.bizunited.platform.core.entity.RbacSettingEntity;
import com.bizunited.platform.core.repository.RbacSettingRepository;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.List;

/**
 * rbac环境配置服务实现类
 * @Author: Paul Chan
 * @Date: 2019-11-25 15:57
 */
@Service("RbacSettingServiceImpl")
public class RbacSettingServiceImpl implements RbacSettingService {

  @Autowired
  private RbacSettingRepository rbacSettingRepository;


  @Override
  @Transactional
  public void init() {
    List<RbacSettingEntity> settings = rbacSettingRepository.findAll();
    if(!CollectionUtils.isEmpty(settings)) {
      return;
    }
    RbacSettingEntity setting = new RbacSettingEntity();
    setting.setUserGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setUserOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setUserRoleRelation(RbacRelationEnum.MANY_TO_MANY.getRelation());
    setting.setUserPositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setRoleGroupRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setRoleOrgRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setRolePositionRelation(RbacRelationEnum.MANY_TO_ONE.getRelation());
    setting.setOrgPositionRelation(RbacRelationEnum.ONE_TO_MANY.getRelation());
    rbacSettingRepository.save(setting);
  }

  @Override
  @Transactional
  public RbacSettingEntity update(RbacSettingEntity setting) {
    Validate.notBlank(setting.getId(), "更新时主键ID不能为空!!!");
    RbacSettingEntity rbacSetting = rbacSettingRepository.findById(setting.getId()).orElse(null);
    Validate.notNull(rbacSetting, "更新对象不存在，请检查！！！");
    if(setting.getUserGroupRelation() != null) {
      rbacSetting.setUserGroupRelation(setting.getUserGroupRelation());
    }
    if(setting.getUserOrgRelation() != null) {
      rbacSetting.setUserOrgRelation(setting.getUserOrgRelation());
    }
    if(setting.getUserRoleRelation() != null) {
      rbacSetting.setUserRoleRelation(setting.getUserRoleRelation());
    }
    if(setting.getUserPositionRelation() != null) {
      rbacSetting.setUserPositionRelation(setting.getUserPositionRelation());
    }
    if(setting.getRoleGroupRelation() != null) {
      rbacSetting.setRoleGroupRelation(setting.getRoleGroupRelation());
    }
    if(setting.getRoleOrgRelation() != null) {
      rbacSetting.setRoleOrgRelation(setting.getRoleOrgRelation());
    }
    if(setting.getRolePositionRelation() != null) {
      rbacSetting.setRolePositionRelation(setting.getRolePositionRelation());
    }
    if(setting.getOrgPositionRelation() != null) {
      rbacSetting.setOrgPositionRelation(setting.getOrgPositionRelation());
    }
    rbacSettingRepository.save(rbacSetting);
    return rbacSetting;
  }

  @Override
  public RbacSettingEntity findRbacSetting() {
    List<RbacSettingEntity> settings = rbacSettingRepository.findAll();
    if(CollectionUtils.isEmpty(settings)) {
      return null;
    }
    return settings.get(0);
  }

}
