package com.bizunited.platform.core.service.serviceable.model;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 
 *用于服务源的入参类
 * @param
 */
public class InputParamsModel {

  /**
   * 服务名称
   * KuiperServiceMethod注解的name值 ， 就是该服务的唯一标识
   */
  private String serviceName;
  /**
   * 外参
   * http请求的url后边携带的？xxx=yyy&aaa=bbb 这类参数
   */
  private Map<String , Object> params;
  /**
   * 开发者自定义的参数
   */
  private Map<String , Object> customData;
  /**
   * 用于筛选传参的参数模型,以及Map<K,V>参数形式
   * Map<K,V>参数形式会自动包装为携带了筛选信息的数据，
   * 如：只传入id=3，name会自动包装为{paramName：“id”，paramValue：3，oprtType：“EQ”，compareValue：3，sortType：null}的k-v结构
   */
  private List<InvokeOperations> filterParams;

  /**
   * 表单数据
   * 可以是模板，事件，可见性等符合Kuiper扫描自动生成的对象
   */
  private JSONObject formData;
  /**
   * 表单实例活动id信息
   */
  private String instanceActivityId;
  
  
  /**
   * 判断是否有值
   * @return
   */
  public boolean isFilterParamsExist() {
    return !CollectionUtils.isEmpty(this.filterParams);
  }
  
  /**
   * 将筛选参数FilterConditionParams添加到ConditionParams
   * @param params
   * @return
   */
  public void fill(InvokeParams params) {
    if(params == null) {
      return;
    }
    this.filterParams.forEach(e -> params.add(e.getParamName(), e, false));
  }
  
  
  /**
   * 获取筛选操作所传入的参数名集合，并且转换数据
   * @return
   */
  public Set<String> transAndKeys(){
    Set<String> keys = new HashSet<>();
    if(isFilterParamsExist()) {
      for(int index = 0 ; index < this.filterParams.size() ; index++) {
        checkValid(this.filterParams.get(index));
        this.trans(this.filterParams.get(index),index);
        keys.add(this.filterParams.get(index).getParamName());
      }
    }
    return keys;
  }
  
  
  /**
   * 检查传入的筛选条件参数的有效性
   * @return
   */
  @SuppressWarnings("unchecked")
  public void checkValid(InvokeOperations model) {
    Validate.notNull(model, "传入的筛选参数不能为空，请检查!!");
    Validate.notBlank(model.getParamName(),"传入的参数名不能为空，请检查!!");
    if(InvokeOperations.isRegionOprt(model.getOprtType()) || InvokeOperations.isBetweenOprt(model.getOprtType())) {
      Validate.notNull(model.getCompareValue(), "区间范围以及between筛选条件，不能为空！！");
      Validate.isTrue((model.getCompareValue() instanceof List), "区间范围以及between筛选条件，请用数组方式传递！！");
      List<Object> list = (List<Object>) model.getCompareValue();
      Validate.isTrue(list.size() == 2, "区间范围以及between筛选条件，数组长度不为2，请检查!!");
      list.forEach( e -> Validate.notNull(e, "区间范围以及between筛选条件传入的筛选参数不能为空，请检查!!"));
    }else if(InvokeOperations.isInOprt(model.getOprtType())){
      Validate.notNull(model.getCompareValue(), "IN操作的筛选条件，不能为空！！");
      if(model.getCompareValue() instanceof List) {
        List<Object> list = (List<Object>) model.getCompareValue();
        Validate.isTrue(!list.isEmpty(), "IN操作的筛选条件，数组长度必须大于等于1，请检查!!");
        list.forEach( e -> Validate.notNull(e, "IN筛选条件传入的筛选参数不能为空，请检查!!"));
      }
    }else if(StringUtils.equalsIgnoreCase(model.getSortType(), InvokeParams.SortType.ASC.name()) || StringUtils.equalsIgnoreCase(model.getSortType(), InvokeParams.SortType.DESC.name())) {
      
    }else if(!InvokeOperations.nullOprt(model.getOprtType()) && !InvokeOperations.getKeyword().contains(model.getOprtType())){
      Validate.notNull(model.getCompareValue(), "传入的筛选参数不能为空，请检查!!");
    }
  }
  
  /**
   * 当操作符为空并且比较值不为空时，默认操作符为等于
   * 此方法用于筛选传参，用默认值进行转换
   * @param model
   */
  public void trans(InvokeOperations model , int index) {
    if(StringUtils.isNotBlank(model.getSortType())) {
      model.setSortIndex(index);
    }
    
    if(StringUtils.isBlank(model.getOprtType()) && model.getCompareValue() != null) {
      model.setOprtType(InvokeParams.OprtCharType.EQ.name());
    }
  }
  

  public String getInstanceActivityId() {
    return instanceActivityId;
  }

  public void setInstanceActivityId(String instanceActivityId) {
    this.instanceActivityId = instanceActivityId;
  }


  public List<InvokeOperations> getFilterParams() {
    return filterParams;
  }

  public void setFilterParams(List<InvokeOperations> filterParams) {
    this.filterParams = filterParams;
  }

  public String getServiceName() {
    return serviceName;
  }

  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }

  public Map<String, Object> getParams() {
    return params;
  }

  public void setParams(Map<String, Object> params) {
    this.params = params;
  }

  public Map<String, Object> getCustomData() {
    return customData;
  }

  public void setCustomData(Map<String, Object> customData) {
    this.customData = customData;
  }

  public JSONObject getFormData() {
    return formData;
  }

  public void setFormData(JSONObject formData) {
    this.formData = formData;
  }
}
