/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.ButtonEntity;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="ButtonRepository")
public interface ButtonRepository
extends JpaRepository<ButtonEntity, String>,
JpaSpecificationExecutor<ButtonEntity> {
    public ButtonEntity findByCode(String var1);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where button_id = :buttonId and competence_id = :competenceId", nativeQuery=true)
    public void unbindCompetence(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Modifying
    @Query(value="insert into engine_button_competence_mapping(button_id,competence_id) values (:buttonId,:competenceId)", nativeQuery=true)
    public void bindCompetence(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Query(value="select count(*) from engine_button_competence_mapping where button_id = :buttonId and competence_id = :competenceId", nativeQuery=true)
    public long countByCompetenceIdAndButtonId(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Query(value="select b from ButtonEntity b inner join fetch b.competence c left join fetch b.competences cs left join fetch b.roles r where b.id = :id")
    public ButtonEntity findDateilsById(@Param(value="id") String var1);

    @Query(value="select count(*) from ButtonEntity b where b.code = :code")
    public long countByCode(@Param(value="code") String var1);

    @Query(value="select distinct b from ButtonEntity b inner join b.roles r where r.id = :roleId")
    public Set<ButtonEntity> findByRoleId(@Param(value="roleId") String var1);

    @Query(value="select count(*) from ButtonEntity b where b.code = :code and b.id <> :id")
    public long countByCodeWithoutId(@Param(value="code") String var1, @Param(value="id") String var2);

    @Query(value="select b from ButtonEntity b inner join b.competence c where c.id = :competenceId order by b.createTime desc")
    public Set<ButtonEntity> findByCompetenceId(@Param(value="competenceId") String var1);

    @Query(value="select b from ButtonEntity b inner join b.roles r where r.roleCode = :roleCode order by b.createTime desc")
    public Set<ButtonEntity> findByRoleCode(@Param(value="roleCode") String var1);

    @Query(value="select count(*) from ButtonEntity b inner join b.roles where b.id = :id")
    public long countRoleById(@Param(value="id") String var1);

    @Query(value="select count(*) from ButtonEntity b inner join b.competences where b.id = :id")
    public long countCompetenceById(@Param(value="id") String var1);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where button_id = :id", nativeQuery=true)
    public void unbindCompetenceById(@Param(value="id") String var1);

    @Modifying
    @Query(value="delete from engine_role_button_mapping where button_id = :id", nativeQuery=true)
    public void unbindRoleById(@Param(value="id") String var1);
}

