/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

class SQLAuthHorizontalAnalysis {
    private SQLAuthHorizontalAnalysis() {
    }

    static void buildSQLAuthHorizoncal(Set<DataViewAuthHorizontalEntity> auths, Map<SQLCorrelationEnum, Object> map) {
        if (CollectionUtils.isEmpty(auths)) {
            return;
        }
        for (DataViewAuthHorizontalEntity e : auths) {
            DataViewFieldEntity field = e.getField();
            Validate.notNull((Object)field, (String)"\u6a2a\u5411\u6743\u9650\u4e2d\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            SQLAuthHorizontalAnalysis.processAuths(e, field, map);
        }
    }

    private static void processAuths(DataViewAuthHorizontalEntity auth, DataViewFieldEntity field, Map<SQLCorrelationEnum, Object> map) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"EQ", (CharSequence)auth.getOprtType()) || StringUtils.equalsIgnoreCase((CharSequence)"NEQ", (CharSequence)auth.getOprtType())) {
            SQLAuthHorizontalAnalysis.analysisEqConditions(auth, field, map);
        } else {
            SQLAuthHorizontalAnalysis.analysisInConditions(auth, field, map);
        }
    }

    private static void analysisInConditions(DataViewAuthHorizontalEntity auth, DataViewFieldEntity field, Map<SQLCorrelationEnum, Object> map) {
        ArrayList<String> values = new ArrayList<String>();
        if (auth.getParamSourceType() == 2) {
            Set<DataViewAuthHorizontalRelationEntity> authRelations = auth.getAuthRelations();
            for (DataViewAuthHorizontalRelationEntity dataViewAuthHorizontalRelationEntity : authRelations) {
                values.add(dataViewAuthHorizontalRelationEntity.getAuthRelationIds());
            }
        } else {
            Object key;
            Map presets = (Map)map.get((Object)SQLCorrelationEnum.PRESETS);
            Object v = presets.get(key = auth.getField().getFieldName() + "|DataViewAuthHorizontalEntity");
            if (Iterable.class.isAssignableFrom(v.getClass())) {
                Iterable iterable = (Iterable)v;
                for (Object next : iterable) {
                    values.add((String)next);
                }
            } else {
                values.add((String)v);
            }
        }
        ArrayList<String> holders = new ArrayList<String>();
        for (Object e : values) {
            SQLAuthHorizontalAnalysis.addConditionValue(auth, map, e.toString());
            holders.add("?");
        }
        String inPattern = StringUtils.join(holders, (String)",");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" and ").append("s01y01s01").append(".").append(field.getFieldName()).append(" ").append(SQLAuthHorizontalAnalysis.getOprtTypeValue(auth.getOprtType())).append(" (").append(inPattern).append(")");
        SQLAuthHorizontalAnalysis.addConditionSQL(stringBuilder.toString(), map);
    }

    private static void analysisEqConditions(DataViewAuthHorizontalEntity auth, DataViewFieldEntity field, Map<SQLCorrelationEnum, Object> map) {
        String newVal = String.format(" and %s.%s %s %s", "s01y01s01", field.getFieldName(), SQLAuthHorizontalAnalysis.getOprtTypeValue(auth.getOprtType()), "?");
        SQLAuthHorizontalAnalysis.addConditionSQL(newVal, map);
        if (auth.getParamSourceType() == 3) {
            Map presets = (Map)map.get((Object)SQLCorrelationEnum.PRESETS);
            String key = auth.getField().getFieldName() + "|DataViewAuthHorizontalEntity";
            Object object = presets.get(key);
            SQLAuthHorizontalAnalysis.addConditionValue(auth, map, object);
            return;
        }
        Set<DataViewAuthHorizontalRelationEntity> authRelations = auth.getAuthRelations();
        Validate.notEmpty(authRelations, (String)"\u6709\u6a2a\u5411\u6743\u9650\u672a\u8bbe\u7f6e\u56fa\u5b9a\u503c", (Object[])new Object[0]);
        for (DataViewAuthHorizontalRelationEntity e : authRelations) {
            SQLAuthHorizontalAnalysis.addConditionValue(auth, map, e.getAuthRelationIds());
        }
    }

    private static void addConditionValue(DataViewAuthHorizontalEntity auth, Map<SQLCorrelationEnum, Object> map, Object idValue) {
        SQLParamModel spm = new SQLParamModel();
        spm.setParamName(auth.getField().getFieldName());
        spm.setTransferType(auth.getParamSourceType());
        spm.setParamType(auth.getParamType());
        spm.setParamKey(auth.getParamKey());
        SQLAuthHorizontalAnalysis.setCounter(spm, map);
        spm.setValue(idValue);
        spm.setSource(DataViewAuthHorizontalEntity.class);
        LinkedHashSet values = (LinkedHashSet)map.get((Object)SQLCorrelationEnum.AUTH_HORIZONTAL_VALUES);
        values.add(spm);
    }

    private static void addConditionSQL(String conditionSQL, Map<SQLCorrelationEnum, Object> map) {
        String oldVal = map.remove((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        String newVal = oldVal + conditionSQL;
        map.put(SQLCorrelationEnum.RESULT_SQL, newVal);
    }

    private static void setCounter(SQLParamModel spm, Map<SQLCorrelationEnum, Object> map) {
        int count = (Integer)map.remove((Object)SQLCorrelationEnum.COUNTER);
        spm.setIndex(count++);
        map.put(SQLCorrelationEnum.COUNTER, count);
    }

    private static String getOprtTypeValue(String oprtType) {
        return InvokeParams.OprtCharType.getOprtValue(oprtType);
    }
}

