/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.common.constant.ParamClassTypeConst;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.repository.internal.ServicableMethodRepositoryCustom;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ServicableMethodRepositoryImpl")
public class ServicableMethodRepositoryImpl
implements ServicableMethodRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String USED_SCOPE = "usedScope";
    private static final String INTERFACE_NAME = "interfaceName";
    private static final String SIMPLE_METHOD_NAME = "simpleMethodName";
    private static final String RETURN_CLASS_NAME = "returnClassName";
    private static final String PROPERTY_CLASS_NAME = "propertyClassName";
    private static final String DESCRIPTION = "description";

    @Override
    public Page<ServicableMethodEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object description;
        Map<String, Object> currentConditions = conditions;
        if (currentConditions == null) {
            currentConditions = new HashMap<String, Object>();
        }
        String hql = "select distinct sm from ServicableMethodEntity sm left join fetch sm.properties smp where 1=1 ";
        String countSql = "select count(*) from engine_service_method sm left join engine_service_method_property smp on sm.id = smp.service_method_id where 1=1 ";
        if (currentConditions.get(USED_SCOPE) != null) {
            hql = hql + " and sm.usedScope = :usedScope ";
            countSql = countSql + " and sm.used_scope = :usedScope ";
        }
        if (currentConditions.get("name") != null) {
            hql = hql + " and sm.name like CONCAT('%', CONCAT(:name, '%')) ";
            countSql = countSql + " and sm.name like CONCAT('%', CONCAT(:name, '%')) ";
        }
        if (currentConditions.get(INTERFACE_NAME) != null) {
            hql = hql + " and sm.interfaceName = :interfaceName ";
            countSql = countSql + " and sm.interface_name = :interfaceName ";
        }
        if (currentConditions.get(SIMPLE_METHOD_NAME) != null) {
            hql = hql + " and sm.simpleMethodName = :simpleMethodName ";
            countSql = countSql + " and sm.simple_method_name = :simpleMethodName ";
        }
        if (currentConditions.get(RETURN_CLASS_NAME) != null) {
            hql = hql + " and sm.returnClassName = :returnClassName ";
            countSql = countSql + " and sm.return_classname = :returnClassName ";
        }
        if (currentConditions.get(PROPERTY_CLASS_NAME) != null) {
            hql = hql + " and smp.paramClass = :propertyClassName ";
            countSql = countSql + " and smp.param_class = :propertyClassName ";
        }
        Object object = description = currentConditions != null ? currentConditions.get(DESCRIPTION) : null;
        if (description != null) {
            hql = hql + " AND sm.description like CONCAT('%',:description,'%') ";
            countSql = countSql + " AND sm.description like CONCAT('%',:description,'%') ";
        }
        hql = hql + " order by sm.name desc ";
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        if (currentConditions.get(USED_SCOPE) != null) {
            query.setParameter(USED_SCOPE, currentConditions.get(USED_SCOPE));
            countQuery.setParameter(USED_SCOPE, currentConditions.get(USED_SCOPE));
        }
        if (currentConditions.get("name") != null) {
            query.setParameter("name", currentConditions.get("name"));
            countQuery.setParameter("name", currentConditions.get("name"));
        }
        if (currentConditions.get(INTERFACE_NAME) != null) {
            query.setParameter(INTERFACE_NAME, currentConditions.get(INTERFACE_NAME));
            countQuery.setParameter(INTERFACE_NAME, currentConditions.get(INTERFACE_NAME));
        }
        if (currentConditions.get(SIMPLE_METHOD_NAME) != null) {
            query.setParameter(SIMPLE_METHOD_NAME, currentConditions.get(SIMPLE_METHOD_NAME));
            countQuery.setParameter(SIMPLE_METHOD_NAME, currentConditions.get(SIMPLE_METHOD_NAME));
        }
        if (currentConditions.get(RETURN_CLASS_NAME) != null) {
            query.setParameter(RETURN_CLASS_NAME, currentConditions.get(RETURN_CLASS_NAME));
            countQuery.setParameter(RETURN_CLASS_NAME, currentConditions.get(RETURN_CLASS_NAME));
        }
        if (currentConditions.get(PROPERTY_CLASS_NAME) != null) {
            query.setParameter(PROPERTY_CLASS_NAME, currentConditions.get(PROPERTY_CLASS_NAME));
            countQuery.setParameter(PROPERTY_CLASS_NAME, currentConditions.get(PROPERTY_CLASS_NAME));
        }
        if (description != null) {
            query.setParameter(DESCRIPTION, currentConditions.get(DESCRIPTION));
            countQuery.setParameter(DESCRIPTION, currentConditions.get(DESCRIPTION));
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List<ServicableMethodEntity> resutls = this.transParamClassType(query.getResultList());
        BigInteger count = (BigInteger)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, (long)count.intValue());
    }

    private List<ServicableMethodEntity> transParamClassType(List<ServicableMethodEntity> resutls) {
        for (ServicableMethodEntity method : resutls) {
            if (method.getProperties() == null || method.getProperties().size() <= 0) continue;
            for (ServicableMethodPropertyEntity param : method.getProperties()) {
                if (!ParamClassTypeConst.baseClassMapContainsKey(param.getParamClass()).booleanValue()) continue;
                param.setParamClass(ParamClassTypeConst.getBaseClass(param.getParamClass()).toString());
            }
        }
        return resutls;
    }
}

