/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.internal;

import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.repository.DictItemRepository;
import com.bizunited.platform.core.repository.DictRepository;
import com.bizunited.platform.core.service.DictItemService;
import com.bizunited.platform.core.service.DictService;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DictItemServiceImpl")
public class DictItemServiceImpl
implements DictItemService {
    private static final String ERROR_MESS = "\u5b57\u5178\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictItemRepository dictItemRepository;
    @Autowired
    private DictService dictService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<DictItemEntity> findItemsByCode(String dictCode) {
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        if (dictEntity == null) {
            return Lists.newArrayList();
        }
        return this.dictItemRepository.findByDictEntityOrderByDictSort(dictEntity);
    }

    @Override
    @Transactional
    public Set<DictItemEntity> save(String dictCode, Set<DictItemEntity> items) {
        DictEntity dict = this.dictService.findByDictCode(dictCode);
        Validate.notNull((Object)dict, (String)"\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01", (Object[])new Object[0]);
        List<DictItemEntity> dictItemsList = this.dictItemRepository.findByDictEntity(dict);
        if (items == null) {
            items = new HashSet<DictItemEntity>();
        }
        this.saveValidation(dictCode, items, dictItemsList);
        HashSet<DictItemEntity> needInsertDictItems = new HashSet<DictItemEntity>();
        HashSet needUpdateDictItems = new HashSet();
        HashSet needDeleteDictItems = new HashSet();
        this.nebulaToolkitService.collectionDiscrepancy(items, dictItemsList, DictItemEntity::getDictValue, needDeleteDictItems, needUpdateDictItems, needInsertDictItems);
        int itemNum = CollectionUtils.isEmpty(needUpdateDictItems) ? items.size() + dictItemsList.size() : items.size() - needUpdateDictItems.size() + dictItemsList.size();
        dict.setItemNum(itemNum);
        dict.setDictItemEntities(null);
        this.dictRepository.saveAndFlush(dict);
        this.dictItemRepository.flush();
        needInsertDictItems.stream().forEach(dictItem -> {
            dictItem.setId(null);
            dictItem.setCreateTime(new Date());
            dictItem.setDictSort(dictItem.getDictSort() == null ? 1 : dictItem.getDictSort());
            dictItem.setDictEntity(dict);
            dictItem.setDictItemStatus(dictItem.getDictItemStatus() == null ? Boolean.TRUE : dictItem.getDictItemStatus());
        });
        this.dictItemRepository.saveAll(needInsertDictItems);
        return needInsertDictItems;
    }

    @Override
    @Transactional
    public DictItemEntity create(String dictCode, DictItemEntity dictItem) {
        this.createValidation(dictCode, dictItem);
        DictEntity dict = this.dictService.findByDictCode(dictCode);
        dict.setItemNum(dict.getItemNum() + 1);
        this.dictRepository.save(dict);
        dictItem.setCreateTime(new Date());
        dictItem.setDictSort(dictItem.getDictSort() == null ? 1 : dictItem.getDictSort());
        dictItem.setDictEntity(dict);
        dictItem.setDictItemStatus(dictItem.getDictItemStatus() == null ? Boolean.TRUE : dictItem.getDictItemStatus());
        return (DictItemEntity)this.dictItemRepository.save(dictItem);
    }

    private void createValidation(String dictCode, DictItemEntity dictItem) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        DictEntity dict = this.dictService.findByDictCode(dictCode);
        Validate.notNull((Object)dict, (String)"\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dictItem, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((dictItem.getId() == null ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u6570\u636eID\u5fc5\u987b\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItem.getDictKey(), (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItem.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        long countByDictKey = this.dictItemRepository.countByDictKeyAndDictId(dictItem.getDictKey(), dict.getId());
        Validate.isTrue((countByDictKey == 0L ? 1 : 0) != 0, (String)"\u5b57\u5178\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        long countByDictValue = this.dictItemRepository.countByDictValueAndDictId(dictItem.getDictValue(), dict.getId());
        Validate.isTrue((countByDictValue == 0L ? 1 : 0) != 0, (String)"\u5b57\u5178\u503c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DictItemEntity enable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)ERROR_MESS, (Object[])new Object[0]);
        DictItemEntity dictItemEntity = this.dictItemRepository.findDetailById(dictItemId);
        Validate.notNull((Object)dictItemEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        dictItemEntity.setDictItemStatus(true);
        return (DictItemEntity)this.dictItemRepository.save(dictItemEntity);
    }

    @Override
    @Transactional
    public DictItemEntity disable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)ERROR_MESS, (Object[])new Object[0]);
        DictItemEntity dictItemEntity = this.dictItemRepository.findDetailById(dictItemId);
        Validate.notNull((Object)dictItemEntity, (String)ERROR_MESS, (Object[])new Object[0]);
        dictItemEntity.setDictItemStatus(false);
        return (DictItemEntity)this.dictItemRepository.save(dictItemEntity);
    }

    private void saveValidation(String dictCode, Set<DictItemEntity> items, List<DictItemEntity> dictItemsList) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Collection<DictItemEntity> dictItemCollection = this.nebulaToolkitService.copyCollectionByWhiteList(dictItemsList, DictItemEntity.class, DictItemEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList oldItems = Lists.newArrayList(dictItemCollection);
        HashSet<DictItemEntity> needInsertItems = new HashSet<DictItemEntity>();
        needInsertItems.addAll(items);
        Map<String, DictItemEntity> oldItemsMap = oldItems.stream().collect(Collectors.toMap(DictItemEntity::getDictValue, e -> e));
        items.forEach(item -> {
            DictItemEntity dictItemEntity = (DictItemEntity)oldItemsMap.get(item.getDictValue());
            if (null != dictItemEntity) {
                needInsertItems.remove(item);
                dictItemEntity.setDictKey(item.getDictKey());
            }
        });
        HashSet dictItemValues = new HashSet();
        HashSet dictItemKeys = new HashSet();
        items.forEach(item -> {
            Validate.notNull((Object)item, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getDictKey(), (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((!dictItemValues.contains(item.getDictValue()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u503c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((!dictItemKeys.contains(item.getDictKey()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            dictItemValues.add(item.getDictValue());
            dictItemKeys.add(item.getDictKey());
        });
        needInsertItems.addAll(oldItems);
        HashSet dbDictItemKeys = new HashSet();
        needInsertItems.forEach(item -> {
            Validate.isTrue((!dbDictItemKeys.contains(item.getDictKey()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            dbDictItemKeys.add(item.getDictKey());
        });
    }
}

